/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: xdphysio.h,v 1.5 2002/07/15 04:30:28 cmalek Exp $
** Program: dowl
**  Module: dowlio.h
**  Author: mazer
** Descrip: this is the main header file for all dowl stuff!
**	    sort of like stdio -- but for dowl library users..
**
** Revision History (most recent last)
**
** Tue Aug 24 14:10:46 1993 mazer
**  removed memtrack and mnemosyne stuff..
**
** Fri Oct 21 12:56:49 1994 mazer
**  NBITS and xword are should now be defined on the command
**  line (i.e. in the config.local or template.* files -- the
**  definitions here are only in case of disaster!
**
*******************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>

#include "misc.h"		/* for NBITS def */

#if !defined(xword)
# define xword short
#endif

#if !defined(NBITS)
# if defined(sparc) || defined(__linux__) || defined(sgi)
#  define NBITS 16
# elif defined (mc700)
#  define NBITS 12
# else
#  define NBITS 16
# endif
#endif

/*
** these are to shut up strict argument/return checking with gcc/lint
** .. this is rather dangerous, since it defeats the whole purpose of
**    arg/ret checking, but it'll have to until the whole this is
**    ansi-fied.
*/

#ifdef sparc
extern int strcasecmp(), strncasecmp();
extern int fprintf(), printf(), vprintf(), vsprintf();
extern int fscanf(), scanf(), sscanf();
extern int puts(), fputs(), fputc();
extern int atoi();
extern int unlink();
extern int getpid();
extern int chdir();
extern int write(), read(), close();
extern int dup(), dup2();
extern int system();
extern char *getenv();
extern char *getcwd();
extern void perror();
extern void bcopy(), bzero();
extern unsigned int alarm();
extern time_t time();
extern long random();
extern int gettimeofday();
extern int vfprintf();
extern int rename();
extern void rewind();
extern char *memset();

extern int fwrite(), fread(), fclose(), pclose(), fflush();
#endif


/*
** sys/types declares: malloc, calloc, free and friends..
*/

#include <sys/types.h>

/* this is a useful save free function */
#define FREE(p) if ((p)) {free((p)); (p) = NULL;}
