/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: xdphys_pms.c,v 1.9 2002/07/15 04:30:27 cmalek Exp $
** Program: dowl
**  Module: xdowl_pms.c
**  Author: mazer
** Descrip: place to install special purpose plot methods
**          associated with certain types of datafiles
**
** Revision History (most recent last)
**
** Fri Nov 19 14:46:21 1993 mazer
**  added ditd module stub
**
** Sat Nov 20 18:45:44 1993 mazer
**  added itd module stub
**
** Mon Nov 22 23:29:13 1993 mazer
**  changed install_plotters() to install_plotMethods()
**  changed filename from xdowlplots.c to xdowl_pms.c
**
** Sat Oct 29 16:23:59 1994 mazer
**  moved plotMethod bindings to <modulename>_init() functions
**  so they can be called when dynamically loaded using dld..
**
*******************************************************************/

#include "xdphyslib.h"
#include "xdphys.h"
#include "xdphys_pms.h"

void install_xdphys_plotMethods(void)
{
	pm_abi_init();
	pm_bf_init();
	pm_cf_init();
	pm_itd_init();
	pm_iid_init();
	pm_rover_init();
	pm_gen_init();
	pm_bja_init();
	pm_fiid_init();
	pm_bc_init();
	pm_beats_init();
	pm_bam_init();
	pm_nop_init();
	pm_txt_init();
/*
  pm_ana_init();
  pm_mono_init();
  pm_sps_init();
*/
}
