/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: xdphys.h,v 1.9 2002/07/15 04:30:27 cmalek Exp $
** Program: dowl
**  Module: dowlmain.h
**  Author: mazer
** Descrip: general globals and junk for dowlmain modules
**
** Revision History (most recent last)
**
*******************************************************************/

#ifndef _XDPHYS_H
#define _XDPHYS_H

#define TEMP_NAMED  -1
#define TEMP_NO     0
#define TEMP_YES    1

#define APPEND_NO    0
#define APPEND_RANGE 1
#define APPEND_REPS  2

typedef struct _RunData {
	char *depvar;		/* name of dependent var */
	char *suffix;		/* suffix of datafile */
	char *helpfile;		/* search string for helpfile */
	int (*pre_fn) (void);	/* pre fopen() function */
	int (*scan_fn) (FILE *, Widget);	/* runApp function */
	int (*post_fn) (char *);	/* post fopen() function */
	int (*display_fn) (char *);
	FieldList params;	/* parameter list (ws) */
	int nparams;		/* num of parameters */
} RunData;

extern TRACER *main_tracer;

extern void unlock_most_worksheets(void);
extern void *make_module_info(char *, char *, char *, int (*)(void),
			      int (*)(FILE *, Widget), int (*)(char *),
			      int (*)(char *), FieldList, int);
extern Widget make_start_temp(Widget, RunData *, XtCallbackProc,
			      XtCallbackProc, DockSlot *);
extern void perc_done(void);
extern int update_displays(int *, int);
extern int default_display_fn(char *);

#endif /* _XDPHYS_H */
