/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: xcalibur.h,v 1.7 2002/07/15 04:30:26 cmalek Exp $
** Program: dowl
**  Module: calib.h
**  Author: bjarthur
** Descrip: general globals and junk for dowlmain modules
**
** Revision History (most recent last)
**
*******************************************************************/

#define TEMP_NAMED  -1
#define TEMP_NO     0
#define TEMP_YES    1

#define ROOT2 1.41421356237

typedef struct _RunData {
	char *depvar;		/* name of dependent var */
	char *suffix;		/* suffix of datafile */
	char *helpfile;		/* search string for help file */
	int (*pre_fn) (void);	/* pre fopen() function */
	int (*scan_fn) (FILE *, Widget);	/* runApp function */
	int (*post_fn) (void);	/* post fopen() function */
	int (*display_fn) (void);
	FieldList params;	/* parameter list (ws) */
	int nparams;		/* num of parameters */
} RunData;

extern void unlock_worksheets(void);
extern void *make_module_info(char *, char *, char *, int (*)(void),
			      int (*)(FILE *, Widget), int (*)(char *),
			      int (*)(char *), FieldList, int);
extern void make_start_temp(Widget, RunData *, XtCallbackProc,
			    XtCallbackProc, DockSlot *);
extern void plottrace(void);
extern int clipCheck(xword *, int, int, float);
extern int load_mic_adjust_data(int, float *, float *);
extern void query_mic_adjust(float, char, float *, float *);

extern int fr_get_ndata(FILEDATA *);
extern float *fr_get_freqs(FILEDATA *);
extern float *fr_get_lmags(FILEDATA *);
extern float *fr_get_rmags(FILEDATA *);
extern float *fr_get_lphis(FILEDATA *);
extern float *fr_get_rphis(FILEDATA *);

extern int default_display_fn(char *);
