/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: ws.h,v 2.51 2002/07/15 04:30:25 cmalek Exp $
** Program: dowl
**  Module: ws.h
**  Author: mazer
** Descrip: interface for ws.c
**
** Revision History (most recent last)
**  
*******************************************************************/

#define MISMATCH_NO    0
#define MISMATCH_YES   1
#define MISMATCH_RANGE 2
#define MISMATCH_REPS  3

typedef struct field *FieldList;
typedef struct field {
	/* "Public" slots */
	char *ws_prompt;	/* name&prompt - NULL for last slot!! */
	char *ws_type;		/* variable type - c format string */
	int ws_length;		/* max length of user-entered value string */
	char *ws_default;	/* client specifed default value */
	/* "Private" slots */
	char *wsi_value;	/* MALLOC: internal widget value */
	Widget wsi_label;	/* associated label widget */
	Widget wsi_text;	/* associated text widget */
	Widget wsi_typelabel;	/* associated type-label widget */
	char *wsi_svar;		/* MALLOC: svar name (1st word of prompt) */
	FieldList wsi_prev;	/* next field number */
	FieldList wsi_next;	/* previous field number */
	int wsi_lit;		/* currently lit up? */
} Field;

#define WS_MAX_DISP_LENGTH (80)


#define WS_HSEP 		"#hsep#"
#define WS_VSEP 		"#vsep#"

#define ISHSEP(x) (strncmp(x,WS_HSEP,strlen(WS_HSEP))==0)
#define ISVSEP(x) (strncmp(x,WS_VSEP,strlen(WS_VSEP))==0)
#define ISSEP(x) (ISHSEP(x) || ISVSEP(x))

#if(0)
#define WS_SEP 		"#sep#"
#define ISSEP(x) (strncmp(x,WS_SEP,strlen(WS_SEP))==0)
#endif

#define MAXFIELDS	200	/* maximum table size (number of slots) */

#define WS_PRELOAD     (-1)

#define WS_N(t)		(sizeof((t)) / sizeof(Field))

extern Widget ws_new(Widget, FieldList, char *, FieldList *, SVAR_TABLE *);
extern Widget pop_ws_new(Widget, FieldList, char *, Widget *,
			 FieldList *, SVAR_TABLE *);
extern int ws_verify(FieldList *);
extern void ws_tosvars(FieldList *, SVAR_TABLE *);	/* WORKSHEET -->  SVARS */
extern void ws_tows(FieldList *, SVAR_TABLE *);	/* SVARS --> WORKSHEET */
extern void ws_write(FILE *, FieldList, int, SVAR_TABLE *);
/*
extern int		ws_check_params(FILEDATA*, FieldList, int, char*);
*/

extern void ws_writeconfig(char *, FieldList, int, SVAR_TABLE *);
extern void ws_preload(FieldList, int);
extern void ws_lock(FieldList, int);
