/*
 * ** This file is part of XDowl
 * ** Copyright (c) 1994 Jamie Mazer
 * ** California Institute of Technology
 * ** <mazer@asterix.cns.caltech.edu>
 */

/******************************************************************
**  RCSID: $Id: synthlib.c,v 1.10 2005/01/30 09:50:13 bjorn Exp $
** Program: xdphys
**  Module: synthlib.c
**  Author: bjarthur
** Descrip: interface to new synth lib
**
** Revision History (most recent last)
**
** 98.11 bjarthur
**  created
**
*******************************************************************/

#include "xdphyslib.h"
#include "pm_cal.h"

int load_calib_data(char *fname, int reload)
{
	int choice;
	FILEDATA *fd;
	char *foo;

	if (cal_get_nfreqs() != 0) {
		if (reload == CAL_RELOAD_NO)
			return (1);
		else if (reload == CAL_RELOAD_ASK) {
			if (pop_box
			    ("load_earcal_data: calibration data already loaded",
			     "use loaded", "reload", NULL) == 1)
				return (1);
		}
		cal_SetData(0, NULL, NULL, NULL, NULL, NULL, 0);
	}

	if (fname == NULL)
		fname = "ear.cal";
	if (!probefile(fname)) {
		choice =
		    pop_box
		    ("Specified/default calibration file doesn't exist...",
		     "Assume flat", "Specify alternate", "Fail");
		switch (choice) {
		case (1):
			cal_FakeFlatCal(&foo);
			SS("caltype", foo);
			return (1);
			break;
		case (2):
			fname =
			    fileBox(".cal", "r", "Calibration file...");
			break;
		case (3):
			return (0);
		}
	}

	SS("caltype", fname);

	if ((fd = FD_read(fname, 0)) == NULL) {
		syn_alert("Can't read calibration file.");
		return (0);
	}
	if (strcmp(fd->modname, "cal")) {
		syn_alert("Calibration file is not a .cal file");
		return (0);
	}

	cal_SetData(pm_cal_get_ndata(fd), pm_cal_get_freqs(fd),
		    pm_cal_get_lmags(fd), pm_cal_get_rmags(fd),
		    pm_cal_get_lphis(fd), pm_cal_get_rphis(fd),
		    probefile(fname));

	if (pm_cal_get_ndata(fd) == 0)
		notify("Warning: calibration file seems to be empty.");
	if (pm_cal_get_ndata(fd) < cal_get_nfreqs())
		notify
		    ("Warning: calibration file is too large to fit in alloc'd memory!");

	SS("caltype", fname);

	FD_free(fd);

	return (cal_get_nfreqs());
}


void plot_calib_data(void)
{
	int npts[2];
	float *x[2], *y[2];
	char *colors[2];

	if (cal_get_nfreqs() != 0) {
		npts[0] = npts[1] = cal_get_nfreqs();
		colors[0] = "red";
		colors[1] = "darkgreen";
		x[0] = x[1] = cal_get_ref_freqs();
		y[0] = cal_get_rdbspl();
		y[1] = cal_get_ldbspl();
		atgraph_quick("Magnitude", "Freq (Hz)", "SPL (dB)", 2,
			      colors, npts, x, y, NULL, 1);
		y[0] = cal_get_rusphi();
		y[1] = cal_get_lusphi();
		atgraph_quick("Phase", "Freq (Hz)", "ITD (us)", 2, colors,
			      npts, x, y, NULL, 1);
	} else {
		alert("No earcal data loaded");
	}
}

static float synl_get_bb_low_freq(void)
{
	return ((float) GI("noise.low"));
}

static float synl_get_bb_high_freq(void)
{
	return ((float) GI("noise.high"));
}

static int synl_get_dafc(void)
{
	return (is_daFc);
}

static int synl_get_tone_rad_vary(void)
{
	return (GI("tone.rad_vary"));
}

static int synl_get_stack_rms(void)
{
	return (GI("stack.rms"));
}

static int synl_get_use_cache(void)
{
	return (GI("use_cache"));
}

void synth_init(void)
{
	syn_alert = alert;
	syn_notify = notify;
	syn_get_rad = getRad;

	syn_tone_rad_vary = synl_get_tone_rad_vary;
	syn_stack_rms = synl_get_stack_rms;

	syn_bb_low_freq = synl_get_bb_low_freq;
	syn_bb_high_freq = synl_get_bb_high_freq;

	syn_dafc = synl_get_dafc;

	cal_max_atten = attMaxAtten;
	syn_spont = SPONT;

	syn_use_cache = synl_get_use_cache;
}
