
/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: svars.h,v 2.49 2002/07/15 04:30:23 cmalek Exp $
** Program: xdphys
**  Module: svars.h
**  Author: mazer
** Descrip: interface file for svars.c
**
** Revision History (most recent last)
**
** Fri Sep 18 10:12:02 1992 mazer
**   merging changes dhb made for monkey vision applications
**  
*******************************************************************/

#ifndef _SVARS_H_
#define _SVARS_H_

typedef struct svar_node {
	int sv_hashval;		/* hash_string(sv_name) */
	char *sv_name;		/* actual svar name */
	char *sv_value;		/* svar value as string */
	struct svar_node *sv_next;	/* svar value as string */
} SVAR;

typedef struct {
	int svt_size;		/* number of entries in this hash table */
	SVAR *svt_table;	/* pointer to the hashtable array itself */
	SVAR *svt_head;		/* head of the table for sorting.. */
} SVAR_TABLE;

/*
** stuff for external tracing
*/
extern void (*svar_read_hook) ();	/* called before each read */
extern void (*svar_write_hook) ();	/* called after each write */
extern void (*svar_changed_hook) ();	/* called before each change */
extern void (*svar_post_changed_hook) ();	/* called after each change */

/*
** general use globals..
*/
extern int LastVarUndefined;
extern SVAR_TABLE *global_svar_table;

/*
** now the functions you can use..
*/
extern void initsvars(void);
extern SVAR_TABLE *new_hash_table(SVAR_TABLE *, int);
extern SVAR_TABLE *varsnew(int, int);

extern char *getvar_match(char *, SVAR_TABLE *, int *);

extern char *getvar(char *, SVAR_TABLE *);
extern int getvar_int(char *, SVAR_TABLE *);
extern float getvar_float(char *, SVAR_TABLE *);
extern int getvar_bool(char *, SVAR_TABLE *);

extern int as_int(char *);
extern float as_float(char *);
extern int as_bool(char *);

extern void sv_stats(SVAR_TABLE *);
extern char *setvar(char *, char *, SVAR_TABLE *);
extern int setvar_int(char *, int, SVAR_TABLE *);
extern float setvar_float(char *, float, SVAR_TABLE *);

extern int fp_loadvars(FILE *, SVAR_TABLE *);
extern int loadvars(char *, SVAR_TABLE *);
extern int fp_savevars(FILE *, SVAR_TABLE *);
extern int savevars(char *, SVAR_TABLE *);
extern void varsprint(SVAR_TABLE *);

extern SVAR *varsfirst(SVAR_TABLE *);	/* first node of table */
extern SVAR *varsnext(SVAR_TABLE *, SVAR *);	/* interate through table */
extern void varsdelete(SVAR_TABLE *);	/* delete a hash table */

extern char *vars2ascii(SVAR_TABLE *);


/*
 * convenience macros .. to save line space :-)
 */

#define GS(p)  		getvar((p), global_svar_table)
#define GI(p)  		getvar_int((p), global_svar_table)
#define GF(p)  		getvar_float((p), global_svar_table)
#define GB(p)  		getvar_bool((p), global_svar_table)

#define SS(p,v)		setvar((p), (v), global_svar_table)
#define SI(p,v)		setvar_int((p), (v), global_svar_table)
#define SF(p,v)		setvar_float((p), (v), global_svar_table)

#define VN(v)		(v)->sv_name
#define VV(v)		(v)->sv_value


extern char *getpref(char *, char *);

#endif				/* _SVARS_H_ */
