/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: statline.c,v 2.47 2002/07/15 04:30:23 cmalek Exp $
** Program: dowl
**  Module: statline.c
**  Author: mazer
** Descrip: status lines -- really just labels
**
** Revision History (most recent last)
**
** Sat Dec 11 13:53:19 1993 mazer
**  changed the busybox_new/_kill() stuff to simply buzy()
**
*******************************************************************/

#include "xdphyslib.h"

static Cursor busy_cursor = (Cursor) None;

static void BusyCursor(Widget);
static void NoBusyCursor(Widget);

Widget statline_named_new(Widget parent, int cwidth, char *name)
{
	Widget w;
	int cw;

	w = XtVaCreateManagedWidget(name, labelWidgetClass, parent,
				    XtNborderWidth, 0,
				    XtNjustify, XtJustifyLeft,
				    XtNlabel, "",
				    XtNresizable, True, NULL);
	char_size(w, &cw, NULL);
	XtVaSetValues(w, XtNwidth, cw * cwidth, NULL);
	return (w);
}

Widget statline_new(Widget parent, int cwidth)
{
	return (statline_named_new(parent, cwidth, "statline"));
}

Widget pop_statline_new(Widget parent, int cwidth, char *name, Widget * s)
{
	Widget pshell;

	pshell = pop_new(parent, name);
	*s = statline_named_new(pshell, cwidth, "statline");
	return (pshell);
}

void statline_set(Widget w, char *fmt, ...)
{
	char tmpbuf[200];
	va_list args;

	va_start(args, fmt);
/*
  w = (Widget) va_arg(args, void *);
  fmt = (char *) va_arg(args, char *);
*/
	if (fmt) {
		vsprintf(tmpbuf, fmt, args);
		XtVaSetValues(w, XtNlabel, tmpbuf, NULL);
	} else {
		XtVaSetValues(w, XtNlabel, "", NULL);
	}
	va_end(args);
}

static void BusyCursor(Widget w)
{
	static int first_time = 1;
	Cursor old_cur;

	if (first_time) {
		busy_cursor = XCreateFontCursor(XtDisplay(w), XC_watch);
		first_time = 0;
	}
	/* this is a hack to set the cursor, only if the widget it question
	 * doesn't have it's own XtNcursor. I think that if the widget being
	 * queried doesn't have an XtNcursor property, then old_c never get's
	 * initialized --> generating a purify error. The solution is to
	 * preset old to busy_cursor.  If the widget's XtNcursor has not been
	 * set, then old_cur will be None, if it has been set, or doesn't
	 * support the XtNcursor resource, old_cur will be busy_cursor and
	 * it won't be busy-fied.
	 */
	old_cur = None;
	XtVaGetValues(w, XtNcursor, &old_cur, NULL);
	if (old_cur == None)
		XtVaSetValues(w, XtNcursor, busy_cursor, NULL);

}

static void NoBusyCursor(Widget w)
{
	Cursor cur;

	cur = None;		/* same idea as BusyCursor() above */
	XtVaGetValues(w, XtNcursor, &cur, NULL);
	if (cur == busy_cursor)
		XtVaSetValues(w, XtNcursor, None, NULL);
}

#if(0)
void busy()
{
	char *fmt, tmpbuf[200];
	static Widget psh = NULL, sline = NULL;
	static int popped = 0;
	va_list args;

	va_start(args);
	fmt = (char *) va_arg(args, char *);
	if (TopLevel == NULL) {
		if (fmt != NULL) {
			vfprintf(stderr, fmt, args);
			fflush(stderr);
		} else {
			fprintf(stderr, ".. done\n");
		}
	} else {
		if (fmt != NULL) {
			if (*fmt) {
				if (psh == NULL) {
					psh = pop_new(NULL, "BusyBox");
					sline =
					    statline_named_new(psh, 40,
							       "statline");
				}
				vsprintf(tmpbuf, fmt, args);
				statline_set(sline, tmpbuf);
				if (!popped) {
					popup_pointer(psh);
					popped = 1;
				}
			}
			ApplyToAllWidgets(TopLevel, BusyCursor);
			dloop_sync();
		} else {
			ApplyToAllWidgets(TopLevel, NoBusyCursor);
			if (psh != NULL && popped) {
				popdown(psh);
				popped = 0;
			}
			dloop_sync();
		}
	}
	va_end(args);
}
#endif
