/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: smenu.c,v 2.47 2002/07/15 04:30:22 cmalek Exp $
** Program: dowl
**  Module: smenu.c
**  Author: mazer
** Descrip: simple menu interface
**
** Revision History (most recent last)
**
** Sat Apr  9 18:06:19 1994 mazer
**  creation date
**
** 97.1 bjarthur
**  added menubutton_clear for fdobj.c
**
*******************************************************************/

#include "xdphyslib.h"

#include "menu.bm"
#include "check.bm"

Widget menubutton_new(Widget parent, String label, Widget horiz,
		      Widget vert, Widget * menushellp)
{
	Widget button, menu;
	static Pixmap menupix = (Pixmap) NULL;

	if (menupix == None)
		menupix = makePixmap(menu_bits, menu_width, menu_height);

	button =
	    XtVaCreateManagedWidget(label, menuButtonWidgetClass, parent,
				    XtNlabel, label,
				    XtNleftBitmap, menupix,
				    XtNcursorName, "sb_left_arrow",
				    XtNfromHoriz, horiz,
				    XtNfromVert, vert, NULL);
	menu =
	    XtVaCreatePopupShell("menu", simpleMenuWidgetClass, button,
				 NULL);
	*menushellp = menu;
	return (button);
}

void menubutton_clear(Widget button, Widget * shell)
{
	XtDestroyWidget(*shell);
	*shell =
	    XtVaCreatePopupShell("menu", simpleMenuWidgetClass, button,
				 NULL);
}

Widget menubutton_add(Widget menushell, String label,
		      XtCallbackProc callback_fn, XtPointer callback_data)
{
	Widget entry;

	if (label == NULL || *label == 0) {
		entry =
		    XtVaCreateManagedWidget("menusep", smeLineObjectClass,
					    menushell, XtNsensitive, False,
					    XtNvertSpace, 40, NULL);
	} else {
		entry =
		    XtVaCreateManagedWidget("menuentry", smeBSBObjectClass,
					    menushell, XtNlabel, label,
					    XtNvertSpace, 40,
					    XtNleftMargin, check_width + 6,
					    NULL);
		XtAddCallback(entry, XtNcallback, callback_fn,
			      callback_data);
	}
	return (entry);
}


void menubutton_check(Widget item, int i)
{
	static Pixmap check_mark = (Pixmap) NULL;

	if (check_mark == None) {
		check_mark =
		    makePixmap(check_bits, check_width, check_height);
	}

	if (i)
		XtVaSetValues(item, XtNleftBitmap, check_mark, NULL);

	else
		XtVaSetValues(item, XtNleftBitmap, NULL, NULL);
}
