/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: slider.h,v 2.44 2002/07/15 04:30:22 cmalek Exp $
** Program: dowl
**  Module: slider.h
**  Author: mazer
** Descrip: interface for slider.c
**
** Revision History (most recent last)
**
** Wed Feb 24 17:49:09 1993 mazer
**  removed _SLIDER_H junk
**
*******************************************************************/

typedef void *Slider;		/* opaque handle for SliderObj */

typedef struct _Slider {
	float sl_value;		/* actual current slider value */
	float sl_low;		/* low value (initial position) */
	float sl_high;		/* high value */
	float sl_step;		/* step size */
	int sl_delta;		/* has slider changed value? */
	int sl_vert;		/* is slider vertical? */
	int sl_filled;		/* filled or not-filled */
	int sl_umod;		/* user modifiable? */
	Widget sl_output;	/*  associated output label box */
	Widget sl_title;	/*  associated title "button" */
	Widget sl_sbar;		/*  associated scroll bar */
	Widget sl_form;		/* all enclosing form widget */
	char *sl_svar;		/* optional name for dowlvars */
	void (*_setCB) ();	/* function to call when set */
} SliderStruct, *SliderObj;

extern Widget slider_widget(SliderObj);
extern Widget gauge_new(Widget, float);
extern void *slider_new(Widget, char *, float, float, float, float, int,
			int, int, int);
extern void slider_setCB(SliderObj, void (*)());
extern float slider_get(SliderObj);
extern void slider_set_noCB(SliderObj, float);
extern void slider_set(SliderObj, float);
extern int slider_modified(SliderObj);
extern void gauge_set(Widget, float);

#define SL_HORIZ 0
#define SL_VERT	 1

#define SL_TICK  0
#define SL_FILL  1

#define SL_MOD	 1
#define SL_NOMOD 0
