/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: signals.c,v 2.47 2002/07/15 04:30:21 cmalek Exp $
** Program: dowl
**  Module: signals.c
**  Author: mazer
**  Decrip: signal convenience handling routines
**
** Revision History (most recent last)
**
** Fri Jan 22 11:26:57 1993 mazer
**  creation date
**
*******************************************************************/

#include "xdphyslib.h"

#ifndef __linux__
static void sigfatal_handler(int, int, struct sigcontext *, char *);

static void sigfatal_handler(int sig, int code, struct sigcontext *scp,
			     char *addr)
#else				/* __linux__ */
static void sigfatal_handler(int);

static void sigfatal_handler(int sig)
#endif				/* __linux__ */
{
	char *name, *msg, c;
	char todir[MAXPATHLEN];

	switch (sig) {
#ifdef SIGQUIT
	case SIGQUIT:
		name = "SIGQUIT";
		msg = "quit";
		break;
#endif
#ifdef SIGILL
	case SIGILL:
		name = "SIGILL";
		msg = "illegal instruction";
		break;
#endif
#ifdef SIGTRAP
	case SIGTRAP:
		name = "SIGTRAP";
		msg = "trace trap";
		break;
#endif
#ifdef SIGABRT
	case SIGABRT:
		name = "SIGABRT";
		msg = "abort (generated by abort(3) routine)";
		break;
#endif
#ifdef SIGEMT
	case SIGEMT:
		name = "SIGEMT";
		msg = "emulator trap";
		break;
#endif
#ifdef SIGFPE
	case SIGFPE:
		name = "SIGFPE";
		msg = "arithmetic exception";
		break;
#endif
#ifdef SIGBUS
	case SIGBUS:
		name = "SIGBUS";
		msg = "bus error";
		break;
#endif
#ifdef SIGSEGV
	case SIGSEGV:
		name = "SIGSEGV";
		msg = "segmentation violation";
		break;
#endif
#ifdef SIGSYS
	case SIGSYS:
		name = "SIGSYS";
		msg = "bad argument to system call";
		break;
#endif
#ifdef SIGLOST
	case SIGLOST:
		name = "SIGLOST";
		msg = "resource lost (see lockd(8C))";
		break;
#endif
	default:
		name = "?unknown?";
		msg = "Random signal?";
		break;
	}
	fprintf(stderr, "\007%s: %s\n", name, msg);
	fprintf(stderr, "\007  R       -- resend for coredump\n");
	fprintf(stderr, "\007  C <dir> -- cd and resend for coredump\n");
	fprintf(stderr, "\007  E       -- exit w/o coredump\n");
	fprintf(stderr, "\007 Which? ");
	fflush(stderr);
	fflush(stdin);
	fscanf(stdin, "%c", &c);
	switch (c) {
	case 'c':
	case 'C':
		if (fscanf(stdin, "%s", todir) == 1)
			chdir(todir);
	case 'r':
	case 'R':
		signal(sig, SIG_DFL);	/* restore default handler */
		fprintf(stderr, "Chugga-chugga-chugga...\n");
		return;
	default:
		fprintf(stderr, "Exiting w/o resending\n");
		exit(1);
	}
}

void sigfatal_setup(void)
{
#ifdef SIGQUIT
	signal(SIGQUIT, sigfatal_handler);
#endif
#ifdef SIGILL
	signal(SIGILL, sigfatal_handler);
#endif
#ifdef SIGTRAP
	signal(SIGTRAP, sigfatal_handler);
#endif
#ifdef SIGABRT
	signal(SIGABRT, sigfatal_handler);
#endif
#ifdef SIGEMT
	signal(SIGEMT, sigfatal_handler);
#endif
#ifdef SIGFPE
	signal(SIGFPE, sigfatal_handler);
#endif
#ifdef SIGBUS
	signal(SIGBUS, sigfatal_handler);
#endif
#ifdef SIGSEGV
	signal(SIGSEGV, sigfatal_handler);
#endif
#ifdef SIGSYS
	signal(SIGSYS, sigfatal_handler);
#endif
#ifdef SIGLOST
	signal(SIGLOST, sigfatal_handler);
#endif
}
