/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: pop.c,v 2.47 2002/07/15 04:30:19 cmalek Exp $
** Program: dowl
**  Module: pop.c
**  Author: mazer
** Descrip: support functions for popup windows
**
** Revision History (most recent last)
** Tue Mar 16 19:56:18 1993 mazer
**  slowly replacing translation hacks with keyboard accel's..
**   done: pop_box, notify()
**
*******************************************************************/

#include "xdphyslib.h"

#include "owl.bm"
#include "alert.bm"

extern Widget TopLevel;
static Pixmap alert_bm;
static int alert_bm_init = 0;
static int npop_box_choice = -1;

static void ButtonHandler(Widget, XtPointer, XtPointer);
static int _pop_box(char *, char *, char *, char *, char *, int, Pixmap);
static void npop_boxCB(Widget, XtPointer, XtPointer);

static void ButtonHandler(Widget w, XtPointer answer_blah,
			  XtPointer call_data)
{
	Widget *answer = (Widget *) answer_blah;

	XtSetSensitive(w, False);
	*answer = w;
	XtSetSensitive(w, True);
}


static int _pop_box(char *name, char *msg, char *l1, char *l2, char *l3,
		    int optbitmap_flag, Pixmap optbitmap)
{
	Widget form, label, icon, pshell;
	Widget b1, b2, b3, answer;
	static Pixmap bitmap;
	static int bitmap_init = 0;

	if (TopLevel == NULL) {
		int resp;
		fprintf(stderr, "%s\n", msg);
		if (l1)
			fprintf(stderr, "1. %s\n", l1);
		if (l2)
			fprintf(stderr, "2. %s\n", l2);
		if (l3)
			fprintf(stderr, "3. %s\n", l3);
		fprintf(stderr, "Choose: ");
		fflush(stderr);
		scanf("%d", &resp);
		return (resp);
	}

	if (bitmap_init == 0) {
		bitmap_init = 1;
		bitmap = makePixmap(owl_bits, owl_width, owl_height);
	}

	pshell = pop_new(TopLevel, name ? name : "Alert");
	form =
	    XtVaCreateManagedWidget("popbox", formWidgetClass, pshell,
				    NULL);
	icon =
	    XtVaCreateManagedWidget("icon", labelWidgetClass, form,
				    XtNbitmap,
				    optbitmap_flag ? optbitmap : bitmap,
				    NULL);

	if (index(msg, '\n') != NULL) {
		char *p, *cpy = strcpy(malloc(strlen(msg) + 1), msg);

		label = icon;
		for (p = strtok(cpy, "\n"); p != NULL;
		     p = strtok(NULL, "\n")) {
			label = label_new(form, p, icon, label, 0);
			XtVaSetValues(label, XtNvertDistance, 0, NULL);
		}
		free(cpy);
	} else {
		label = label_new(form, msg, icon, icon, 0);
	}

	b1 = button_new(form, "b1", "b1", ButtonHandler, &answer, icon,
			label);
	XtVaSetValues(b1, XtNlabel, l1 ? l1 : "Ok", NULL);
	ReverseColors(b1);

	if (l2 != NULL) {
		b2 = button_new(form, "b2", "b2", ButtonHandler, &answer,
				b1, label);
		XtVaSetValues(b2, XtNlabel, l2, NULL);
	} else
		b2 = NULL;
	if (l3 != NULL) {
		b3 = button_new(form, "b3", "b3", ButtonHandler, &answer,
				b2, label);
		XtVaSetValues(b3, XtNlabel, l3, NULL);
	} else
		b3 = NULL;

	if (b1)
		accel_from(form, b1);
	if (b2)
		accel_from(form, b2);
	if (b3)
		accel_from(form, b3);

	popup_pointer(pshell);
	for (answer = NULL; answer == NULL; dloop_empty());
	popdown(pshell);

	XtDestroyWidget(pshell);
	if (answer == b1)
		return (1);
	else if (answer == b2)
		return (2);
	else if (answer == b3)
		return (3);
	else
		return (-1);
}

int pop_box(char *msg, char *l1, char *l2, char *l3)
{
	beep(0);
	return (_pop_box("Alert", msg, l1, l2, l3, 0, 0));
}


int vpop_box(char *l1, char *l2, char *l3, char *fmt, ...)
{
	char buf[1000];
	va_list args;

	va_start(args, fmt);
/*
  l1 = (char *) va_arg(args, char *);
  l2 = (char *) va_arg(args, char *);
  l3 = (char *) va_arg(args, char *);
  fmt = (char *) va_arg(args, char *);
*/
	vsprintf(buf, fmt, args);
	va_end(args);

	beep(0);
	return (_pop_box("Alert", buf, l1, l2, l3, 0, 0));
}

#if(0)
void die(va_alist)
va_dcl
{
	char buf[1000], *fmt;
	va_list args;

	va_start(args);
	fmt = (char *) va_arg(args, char *);
	vsprintf(buf, fmt, args);
	va_end(args);

	if (TopLevel && alert_bm_init == 0) {
		alert_bm_init = 1;
		alert_bm =
		    makePixmap(alert_bits, alert_width, alert_height);
	}
	beep(100);
	_pop_box("Alert", buf, "Exit", NULL, NULL, 1, alert_bm);
	exit(1);
}
#endif

void alert(char *fmt, ...)
{
	char buf[1000];
	va_list args;

	va_start(args, fmt);
/*  fmt = (char *) va_arg(args, char *); */
	vsprintf(buf, fmt, args);
	va_end(args);

	if (TopLevel && alert_bm_init == 0) {
		alert_bm_init = 1;
		alert_bm =
		    makePixmap(alert_bits, alert_width, alert_height);
	}
	beep(0);
	_pop_box("Alert", buf, "Ok", NULL, NULL, 1, alert_bm);
}

void notify(char *fmt, ...)
{
	va_list args;
	char buf[1000];
	Widget form, label, icon, psh, ok;
	static Pixmap bitmap;
	static int bitmap_init = 0;

	va_start(args, fmt);
/*  fmt = (char *) va_arg(args, char *); */
	vsprintf(buf, fmt, args);
	va_end(args);

	if (TopLevel && bitmap_init == 0) {
		bitmap_init = 1;
		bitmap = makePixmap(owl_bits, owl_width, owl_height);
	}

	psh = pop_new(TopLevel, "Notify");
	form =
	    XtVaCreateManagedWidget("popbox", formWidgetClass, psh, NULL);
	icon =
	    XtVaCreateManagedWidget("icon", labelWidgetClass, form,
				    XtNbitmap, bitmap, XtNborderWidth, 0,
				    NULL);
	label = label_new(form, buf, icon, icon, 0);
	ok = button_new(form, "b1", "b1", ClosePShellCB, psh, icon, label);
	XtVaSetValues(ok, XtNlabel, "Dismiss", NULL);
	ReverseColors(ok);
	accel_from(form, ok);
	popup_pointer(psh);
}

char *pop_dialog(char *prompt, char *value)
{
	char *result;
	Widget dialog, pshell, ok, cancel, answer;

	pshell = pop_new(TopLevel, "Dialog");
	dialog =
	    XtVaCreateManagedWidget("popdialog", dialogWidgetClass, pshell,
				    XtNvalue, value, XtNlabel, prompt,
				    NULL);
	XawDialogAddButton(dialog, "Ok", ButtonHandler, &answer);
	ok = XtNameToWidget(dialog, "Ok");
	XawDialogAddButton(dialog, "Cancel", ButtonHandler, &answer);
	cancel = XtNameToWidget(dialog, "Cancel");

	accel_from(dialog, dialog);

	popup_pointer(pshell);	/* was xpopup */
	answer = NULL;
	while (answer != ok && answer != cancel)
		dloop_empty();
	popdown(pshell);

	if (answer == cancel)
		result = NULL;
	else if (answer == ok)
		result = strsave(XawDialogGetValueString(dialog));
	XtDestroyWidget(pshell);

	return (result);
}

char *pop_text(char *title, char *buf, int size, int rw)
{
	Widget pshell, form, done, cancel, label, text, answer;
	int i, j, nlines, nchars, cw, ch;

	nlines = 1;
	nchars = 0;
	for (j = i = 0; buf[i]; i++) {
		if (buf[i] == '\n') {
			nlines++;
			if (j > nchars)
				nchars = j;
			j = 0;
		} else {
			j++;
		}
	}

	pshell = pop_new(TopLevel, title ? title : "Text");
	form =
	    XtVaCreateManagedWidget("poptext", formWidgetClass, pshell,
				    NULL);

	if (rw) {
		done =
		    button_new(form, "Done", "Done", ButtonHandler,
			       &answer, NULL, NULL);
		cancel =
		    button_new(form, "Cancel", "Cancel", ButtonHandler,
			       &answer, done, NULL);
		label = label_new(form, title, cancel, NULL, 0);
	} else {
		done =
		    button_new(form, "Done", "Done", ClosePShellCB, pshell,
			       NULL, NULL);
		label = label_new(form, title, done, NULL, 0);
	}

#ifdef X11R4
	text =
	    XtVaCreateManagedWidget("asciiText", asciiTextWidgetClass,
				    form, XtNeditType,
				    rw ? XawtextEdit : XawtextRead,
				    XtNstring, buf, XtNlength, size,
				    XtNfromVert, label, XtNfromHoriz, NULL,
				    NULL);
#else
	text =
	    XtVaCreateManagedWidget("asciiText", asciiTextWidgetClass,
				    form, XtNuseStringInPlace,
				    rw ? True : False, XtNeditType,
				    rw ? XawtextEdit : XawtextRead,
				    XtNstring, buf, XtNlength, size,
				    XtNfromVert, label, XtNfromHoriz, NULL,
				    XtNscrollHorizontal,
				    XawtextScrollWhenNeeded,
				    XtNscrollVertical,
				    XawtextScrollWhenNeeded,
				    XtNinsertPosition, strlen(buf), NULL);
#endif
	if (char_size(text, &cw, &ch)) {
		if (rw)
			XtVaSetValues(text, XtNwidth, 80 * cw, XtNheight,
				      10 * ch, NULL);
		else
			XtVaSetValues(text,
				      XtNwidth, (nchars + 10) * cw,
				      XtNheight,
				      ((nlines >
					24 ? 24 : nlines) + 1) * ch, NULL);
	}

	accel_from(form, done);
	if (rw)
		accel_from(form, cancel);

	popup_pointer(pshell);
	if (rw) {
		answer = NULL;
		while (answer != done && answer != cancel)
			dloop_empty();
		popdown(pshell);
		XtDestroyWidget(pshell);
		return (answer == done ? buf : NULL);
	} else {
		return (NULL);
	}
}

void pop_file_at(char *title, char *filename, int endp)
{
	Widget pshell, form, done, label, text;
	int cw, ch;
	struct stat sb;

	if (endp && stat(filename, &sb) < 0) {
		perror(filename);
	} else {
		pshell = pop_new(TopLevel, title ? title : "File");
		form =
		    XtVaCreateManagedWidget("form", formWidgetClass,
					    pshell, NULL);
		done =
		    button_new(form, "Close", "Close", ClosePShellCB,
			       pshell, NULL, NULL);
		label = label_new(form, title, done, NULL, 0);
		text =
		    XtVaCreateManagedWidget("asciiFile",
					    asciiTextWidgetClass, form,
					    XtNeditType, XawtextRead,
					    XtNinsertPosition,
					    (int) (endp ? sb.st_size : 0),
					    XtNdisplayPosition,
					    (int) (endp ? 99 * sb.st_size /
						   100 : 0), XtNstring,
					    filename, XtNtype,
					    XawAsciiFile, XtNfromVert,
					    label, XtNscrollHorizontal,
					    XawtextScrollWhenNeeded,
					    XtNscrollVertical,
					    XawtextScrollWhenNeeded, NULL);
		if (char_size(text, &cw, &ch))
			XtVaSetValues(text, XtNwidth, 100 * cw, XtNheight,
				      20 * ch, NULL);

		popup_pointer(pshell);
	}
}

void pop_file(char *title, char *filename)
{
	pop_file_at(title, filename, 0);
}

static void npop_boxCB(Widget w, XtPointer n_blah, XtPointer call_data)
{
	int n = (int) n_blah;

	npop_box_choice = n;
}

int npop_box(char *msg, ...)
{
	char *item;
	int i;
	Widget form, label, icon, pshell, b;
	static Pixmap bitmap;
	static int bitmap_init = 0;
	va_list args;

	va_start(args, msg);
/*
  msg = (char *) va_arg(args, char *);
*/

	if (TopLevel && bitmap_init == 0) {
		bitmap_init = 1;
		bitmap = makePixmap(owl_bits, owl_width, owl_height);
	}

	pshell = pop_new(TopLevel, "Choose");
	form =
	    XtVaCreateManagedWidget("popbox", formWidgetClass, pshell,
				    NULL);
	icon =
	    XtVaCreateManagedWidget("icon", labelWidgetClass, form,
				    XtNbitmap, bitmap, NULL);

	if (index(msg, '\n') != NULL) {
		char *p, *cpy = strcpy(malloc(strlen(msg) + 1), msg);
		label = icon;
		for (p = strtok(cpy, "\n"); p != NULL;
		     p = strtok(NULL, "\n")) {
			label = label_new(form, p, icon, label, 0);
		}
		free(cpy);
	} else {
		label = label_new(form, msg, icon, icon, 0);
	}

	b = label;
	for (i = 0; (item = (char *) va_arg(args, char *)) != NULL; i++) {
		b = button_new(form, item, item, npop_boxCB,
			       (XtPointer) (i + 1), icon, b);
		XtVaSetValues(b, XtNhorizDistance, i * 5, NULL);
	}

	popup_pointer(pshell);	/* was xpopup */
	for (npop_box_choice = -1; npop_box_choice <= 0; dloop_empty());
	popdown(pshell);
	XtDestroyWidget(pshell);

	va_end(args);
	return (npop_box_choice);
}
