/******************************************************************
**  RCSID: $Id: mod_click.c,v 1.6 2002/07/15 04:30:12 cmalek Exp $
** Program: xdphys
**  Module: mod_click.c
**  Author: cmalek
** Descrip: clicks module
**
** Revision History (most recent last)
**
** Sun Nov  26 19:00:00 2000 cmalek
**  creation date -- derived from mod_fiid.c
**
*******************************************************************/

#include "xdphyslib.h"
#include "xdphys.h"

/*
** note: fixed < 0 means fix left, fixed > 0 means fix right
*/

static Field ws_table[] = {
	{"click.itd_range (us)", "%s", 40, "-300:300:30"},
	{WS_VSEP},
	{"click.length (nsamples)", "%s", 30, "1"},
	{"click.type (0=rare,1=cond)", "%b", 1, "0"},
	{WS_VSEP},
	{"click.left_atten (dB)", "%d", 4, "20"},
	{"click.right_atten (dB)", "%d", 4, "20"},
	{WS_VSEP},
	{"click.Side (L,R,B)", "%s", 1, "B"},
	{NULL},
};

static int runScan(FILE *, Widget);
Widget setupFiid(DockSlot *);

static int runScan(FILE * datafp, Widget status)
{
	int delay;		/* stimulus latency in ms */
	int epoch;		/* recording epoch in ms */
	int isi;		/* inter-stimulus interval */
	int nstims, reps;	/* number & reps of stimuli to present */
	int *orig_stimarray;	/* ideal sequence of itds to present */
	int *stimarray;		/* actual sequence of itds to present */
	spike_t *data;		/* pointer to raster data */
	float latten, ratten;	/* digital attenuator settings */
	char *range;		/* range of itds -- useconds */
	void *isitime;		/* handle for isi_functions() */
	char depstr[256];
	int i;
	float *avePMk;
	syn_spec ss;
	char stimspec[20];
	char msg[1024];
	char *sidestr;
	int side;
	int type;
	int nsamples;
	int rand, spont_stims;
	float daFc, evtFc, da_period;
	int ana_every;
	int stim_every;
	double timestamp;
	int retval;
	int outsize, da_channels;
	xword *outbuf;

	/* calculate parameters */
	ws_lock(ws_table, True);

	/* worksheet parameters */
	range = GS("click.itd_range");
	type = GI("click.type");
	nsamples = GI("click.length");
	latten = GF("click.left_atten");
	ratten = GF("click.right_atten");
	sidestr = GS("click.Side");

	/* global parameters */
	reps = GI("reps");
	delay = GI("delay");
	epoch = GI("epoch");
	isi = GI("isi");
	rand = GI("randomize");
	spont_stims = GI("Spont_Stims");

	/* da/ad parameters */
	daFc = GF("daFc");
	da_period = (float) (1.0 / daFc) * 1.0e6;	/* in microseconds */
	evtFc = GF("evtFc");

	ana_every = GI("ana.every");
	stim_every = GI("stim.every");
	ws_lock(ws_table, False);
	unlock_most_worksheets();

	/* no svars should be accessed beyond this point */

	/* create stimspec */
	if ((type != 0) && (type != 1)) {
		alert
		    ("click.type must be either 0 (rarefaction) or 1 (condensation).");
		return (-1);
	} else {
		if (nsamples > (int) ((epoch - delay) * da_period)) {
			sprintf(msg,
				"click.nsamples must be shorter than %d "
				"( = (epoch-delay)*samp_period).",
				(int) ((epoch - delay) * da_period));
			alert(msg);
			return (-1);
		} else {
			switch (type) {
			case 0:
				sprintf(stimspec, "rare_click=%d",
					nsamples);
				break;
			case 1:
				sprintf(stimspec, "cond_click=%d",
					nsamples);
				break;
			}
		}
	}

	/* check stimspec */
	fd_syn_spec_parse(stimspec, 0, &ss);
	if (ss.class == SC_INVALID) {
		alert("Stim: \"%s\" illegal syn_class\n%s",
		      stimspec, synthesize_help());
		return (-1);
	}

	/* syn_calibrate shouldn't do anything for SC_CLICKs but, turn it
	 * off anyway */
	syn_calibrate = 0;

	/* make sure side is ok */
	if (strncmp(sidestr, "L", 1) && strncmp(sidestr, "R", 1)
	    && strncmp(sidestr, "B", 1)) {
		alert("Side parameter must be either L, R or B.");
		return (-1);
	} else {
		if (!strncmp(sidestr, "L", 1))
			side = SYN_LEFT;
		else if (!strncmp(sidestr, "R", 1))
			side = SYN_RIGHT;
		else if (!strncmp(sidestr, "B", 1))
			side = SYN_BOTH;
	}

	if ((orig_stimarray = StimArray_Gen(&nstims, rand,
					    range, reps, 1,
					    spont_stims)) == NULL)
		return (-1);

	/* since we're using offsets in integral numbers of samples to simulate
	 * ITD, we run this through StimArray_ClosestITD() */

	assert((stimarray = StimArray_ClosestITD(orig_stimarray, nstims)) != NULL);

	/* set up some things in iserver; should really put this somewhere
	 * else */
	is_setNice(GI("nicelevel"));
	is_setSyncPulse(GI("syncPulse"));

	/* start up iserver */
	is_init(daFc, 0.0, evtFc, epoch, epoch);

	outbuf = is_getDAbuffer(&outsize);	/* # samples per channel in outbuf */
	da_channels = is_getDAnchans();	/* # channels in outbuf */

	/* this is the main loop */

	fprintf(datafp, "nrasters=%d\n", nstims);
	isitime = isi_start(0);

	for (i = 0; i < nstims && progRunning; i++) {
		set_trial_vars(i, nstims, reps, stimarray[i]);
		perc_done();

		/* synth the stim */
		if (stimarray[i] == SPONT) {
			setRack(0, attMaxAtten, attMaxAtten);
			is_clearOutput(SYN_BOTH);

			statline_set(status, "this is: SPONT");
		} else {
			/* we have to put 1 in for "dur" so synthesize won't
			 * complain. synth.c:syn_click() doesn't use it, though */
			synthesize(&ss, NULL, outbuf, outsize, da_channels,
				   delay, 1, epoch, stimarray[i], 100, 0,
				   0, side);
			setRack(0, latten, ratten);
			statline_set(status,
				     "this is: Latten=%d, Ratten=%d\n",
				     (int) latten, (int) ratten);
		}

		set_led(3, 1);

		/* play/record */
		retval =
		    is_sample(X_TRIG | X_EVT | X_DA, epoch, &timestamp);
		if (!(single_step(retval))) {
			alert("is_sample failed: can't continue run");
			set_progRunning(False);
		} else
			MaybePause();

		set_led(3, 0);

		view_input();
		view_output();

		/* retrieve the spikes */
		data = getRaster(epoch, &avePMk);

		/* write the data to the datafile */
		if (stimarray[i] == SPONT)
			sprintf(depstr, "depvar=%d <SPONT>\n", SPONT);
		else
			sprintf(depstr, "depvar=%d <%dus, wanted %dus>\n",
				stimarray[i], stimarray[i],
				orig_stimarray[i]);

		if (avePMk != NULL)
			printAvePMks(avePMk, ((i + 1) % (nstims / reps) ==
				      0) ? ((i + 1) / (nstims / reps)) : 0, nstims / reps);

		write_data_to_xdphysfile(datafp, data, depstr, avePMk,!(i % ana_every),
			!(i % stim_every), side);

		update_displays(data, 0);
		isi_stop(isitime);

		isitime = isi_start(isi);

		dloop_empty();

		free(data);
	}

	free(orig_stimarray);
	free(stimarray);
	return (progRunning ? 1 : 0);
}

Widget setupClick(DockSlot * slot)
{
	Widget ws, h;

	ws = pop_ws_new(TopLevel, ws_table, "click", &h, NULL, NULL);
	make_start_temp(h,
			make_module_info("itd (us)", "itd", "click", NULL,
					 runScan, NULL, default_display_fn,
					 ws_table, WS_N(ws_table)), NULL,
			NULL, slot);
	return (ws);
}
