/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: mathfns.h,v 2.53 2002/07/15 04:30:10 cmalek Exp $
** Program: xdphys
**  Module: mathfns.h
**  Author: mazer
** Descrip: interface for mathfns.c
**
** Revision History (most recent last)
**
** Thu Sep 16 17:01:08 1993 mazer
**   added some useful macros..
**
*******************************************************************/

#ifndef _MATHFNS_H_
#define _MATHFNS_H_

#define RND2INT(f) ((int)((f) < 0 ? ((f) - 0.5) : ((f) + 0.5)))
#define floatVec(size)	(float*)calloc(size, sizeof(float))

extern float limited_uniform(long *);
extern float lin_interpolate(float, int, float *, float *);
extern float lin_interpolate2(xword *, int, int, float);
extern float cubic_interpolate(xword *, int, int, float);
extern int greatest_common_factor(int, int);


#if(0)
extern int xyfloat_load(char *, float **, float **);

#define NATURALSP	1.0e30
extern void polyfit(float *, float *, int, float **, float **, int, int);
      /* for floats.. */
#endif



#endif				/* _MATHFNS_H_ */
