/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: locks.c,v 2.46 2002/07/15 04:30:09 cmalek Exp $
** Program: dowl
**  Module: locks.c
**  Author: mazer
** Descrip: simple lockout code to avoid hardware collisions
**
** Revision History (most recent last)
**
** Mon Dec 26 12:26:28 1994 mazer
**  this file does NOT use fopen2() for speed..
**
** 98.7 bjarthur
**  rearranged a lot and added a kill() call to kill old process if
**    existing lock is chosen to be ignored
**
*******************************************************************/

#include "xdphyslib.h"

static char *lock_name(char *);

static char *lock_name(char *filename)
{
	static char buf[MAXPATHLEN], *p;

	if ((p = rindex(filename, '/')))
		p++;
	else
		p = filename;

	sprintf(buf, "~/.xdphysrc/LCK_%s", p);
	return (buf);
}

void lockApp(void)
{
	FILE *fp;
	char *lock, *p;
	char *msg = "%s: already in use. Ignore lock?";
	int pid;

	lock = lock_name(progname);

	if ((fp = fopen(findhome(lock), "r")) != NULL) {
		p = (char *) malloc(strlen(msg) + strlen(progname) + 10);
		sprintf(p, msg, progname);
		if (pop_box(p, "No", "Yes", NULL) == 1)
			exit(1);
		fscanf(fp, "pid %d (%*s)", &pid);
		kill(pid, 9);
		fclose(fp);
		unlink(findhome(lock));
		free(p);
	}

	assert((fp = fopen(findhome(lock), "w")) != NULL);
	if ((p = getenv("USER")) == NULL
	    && (p = getenv("LOGNAME")) == NULL)
		p = "whoami";
	fprintf(fp, "pid %d (%s)\n", getpid(), p);
	fclose(fp);
}

void unlockApp(void)
{
	char *p;

	p = findhome(lock_name(progname));

	if (p != NULL)
		unlink(p);
}
