/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: iviewer.c,v 2.50 2002/07/15 04:30:09 cmalek Exp $
** Program: dowl
**  Module: iviewer.c
**  Author: mazer
** Descrip: quick implementatino of view_ouput()
**
** Revision History (most recent last)
**
** Sun Mar 15 11:30:03 1992 mazer
**  creation date
**  
** Sat Jun 27 19:00:42 1992 mazer
**  added view_input() to match view_ouput();
**
*******************************************************************/

#include "xdphyslib.h"

extern Widget TopLevel;
static Widget opsh = NULL, olwv, orwv, olabel;
static Widget ipsh = NULL, ilwv, irwv, ilabel;
static int view_output_mode = 0;
static int view_input_mode = 0;

static void SaveCB(Widget, XtPointer, XtPointer);
static void CloseOutCB(Widget, XtPointer, XtPointer);
static void CloseInCB(Widget, XtPointer, XtPointer);

static void SaveCB(Widget w, XtPointer input_blah, XtPointer call_data)
{
	int input = (int) input_blah;
	xword *buf;
	int paircount;

	if (input) {
		if ((buf = is_getADbuffer(&paircount)) != NULL) {
			savewave("input.snd", buf, is_adFc, paircount, 2,
				 "iviewer waveform", progname, 0.0, 0.0,
				 NULL, 0);
			printf("Saved to input.snd");
		} else {
			notify("no DA buffer");
		}
	} else {
		if ((buf = is_getDAbuffer(&paircount)) != NULL) {
			savewave("output.snd", buf, is_daFc, paircount, 2,
				 "iviewer waveform", progname, 0.0, 0.0,
				 NULL, 0);
			printf("Saved to output.snd");
		} else {
			notify("no DA buffer");
		}
	}
}

static void CloseOutCB(Widget w, XtPointer window_blah,
		       XtPointer call_data)
{
	Widget window = (Widget) window_blah;

	popdown(window);
	view_output_mode = 0;
}

static void CloseInCB(Widget w, XtPointer window_blah, XtPointer call_data)
{
	Widget window = (Widget) window_blah;

	popdown(window);
	view_input_mode = 0;
}

void view_output_init(void)
{
	Widget form, but, w;

	opsh = pop_new(TopLevel, "iviewer-output");
	form = form_new(opsh, "waveform", 0);	/* 0 wasn't there initially */
	but =
	    button_new(form, "Close", "Close", CloseOutCB, opsh, NULL,
		       NULL);
	w = button_new(form, "Save", "Save", SaveCB, 0, but, NULL);
	olabel = label_new(form, "iv.stim", w, NULL, 0);
	olwv = XtVaCreateManagedWidget("Left", waveWidgetClass, form,
				       XtNwidth, 500, XtNheight, 100,
				       XtNshowGrid, True, XtNborderWidth,
				       2, XtNfromVert, but, NULL);
	orwv =
	    XtVaCreateManagedWidget("Right", waveWidgetClass, form,
				    XtNwidth, 500, XtNheight, 100,
				    XtNshowGrid, True, XtNborderWidth, 2,
				    XtNfromVert, olwv, XtNvertDistance, 2,
				    NULL);
	XtWaveLink(olwv, orwv, 1);
	view_output_mode = 1;
	popup(opsh);
}

void view_output(void)
{
	char buf[10];
	xword *outbuf;
	int outsize;

	if (view_output_mode) {
		sprintf(buf, "%d", cur_depvar);
		label_set(olabel, buf);
		outbuf = is_getDAbuffer(&outsize);

		XtVaSetValues(olwv, XtNfc, is_daFc, NULL);
		XtWaveSetWaveform(olwv, outbuf, outsize, 2, -RANGE, RANGE);
		XtVaSetValues(orwv, XtNfc, is_daFc, NULL);
		XtWaveSetWaveform(orwv, outbuf + 1, outsize, 2, -RANGE,
				  RANGE);
	}
}

void view_input_init(void)
{
	Widget form, but, w;

	ipsh = pop_new(TopLevel, "iviewer-input");
	form = form_new(ipsh, "waveform", 0);	/* 0 wasn't there initially */
	but =
	    button_new(form, "Close", "Close", CloseInCB, ipsh, NULL,
		       NULL);
	w = button_new(form, "Save", "Save", SaveCB, (XtPointer) 1, but,
		       NULL);
	ilabel = label_new(form, "iv.stim", w, NULL, 0);
	ilwv = XtVaCreateManagedWidget("Left", waveWidgetClass, form,
				       XtNwidth, 500, XtNheight, 100,
				       XtNshowGrid, True, XtNborderWidth,
				       2, XtNfromVert, but, NULL);
	irwv =
	    XtVaCreateManagedWidget("Right", waveWidgetClass, form,
				    XtNwidth, 500, XtNheight, 100,
				    XtNshowGrid, True, XtNborderWidth, 2,
				    XtNfromVert, ilwv, XtNvertDistance, 2,
				    NULL);
	XtWaveLink(ilwv, irwv, 1);
	view_input_mode = 1;
	popup(ipsh);
}

void view_input(void)
{
	char buf[10];
	xword *inbuf;
	int insize;

	inbuf = is_getADbuffer(&insize);
	if (view_input_mode) {
		sprintf(buf, "%d", cur_depvar);
		label_set(ilabel, buf);
		XtVaSetValues(ilwv, XtNfc, is_daFc, NULL);
		XtWaveSetWaveform(ilwv, inbuf, insize, 2, -RANGE, RANGE);
		XtVaSetValues(irwv, XtNfc, is_daFc, NULL);
		XtWaveSetWaveform(irwv, inbuf + 1, insize, 2, -RANGE,
				  RANGE);
	}
}
