/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: getfile.c,v 2.47 2002/07/15 04:30:08 cmalek Exp $
** Program: dowl
**  Module: getfile
**  Author: mazer
** Descrip: R4/R5 wrapper for the FileNom widget
**
** Revision History (most recent last)
**
*******************************************************************/

#include "xdphyslib.h"
#include "FileNom.h"
#include "FileNomP.h"

static int fb_cancel = 0;
static char *fb_file = NULL;

static void CancelFB(Widget, XtPointer, XtPointer);
static void SelectFB(Widget, XtPointer, XtPointer);
static void CancelFB_noblock(Widget, XtPointer, XtPointer);
static void SelectFB_noblock(Widget, XtPointer, XtPointer);

static void CancelFB(Widget w, XtPointer pshell_blah, XtPointer call_data)
{
	Widget pshell = (Widget) pshell_blah;

	popdown(pshell);
	fb_cancel = 1;
}

static void SelectFB(Widget w, XtPointer pshell_blah, XtPointer name_blah)
{
	Widget pshell = (Widget) pshell_blah;
	FileNominatorStruct *name = (FileNominatorStruct *) name_blah;
	char *p;

	popdown(pshell);
	p = (char *) malloc(strlen(name->directoryPart) +
			    strlen(name->filenamePart) + 1);
	strcpy(p, name->directoryPart);
	strcat(p, name->filenamePart);
	fb_file = p;
}

char *fileBoxMatch(char *fname, char *mode, char *prompt, char *pattern,
		   int showdirs)
{
	Widget pshell, form, label, filenom;
	char *dirname;
	int i;

	if (*mode == 'w' || *mode == 'W' || *mode == 'a')
		pshell = pop_new(TopLevel, "Write File");
	else
		pshell = pop_new(TopLevel, "Read File");

	if (*fname && fname[strlen(fname) - 1] == '/') {
		dirname = fname;
		fname = NULL;
	} else {
		dirname = NULL;
	}

	form =
	    XtVaCreateManagedWidget("form", formWidgetClass, pshell, NULL);
	label =
	    XtVaCreateManagedWidget("label", labelWidgetClass, form,
				    XtNborderWidth, 0,
				    XtNlabel, prompt, NULL);
	filenom =
	    XtVaCreateManagedWidget("fileNominator",
				    fileNominatorWidgetClass, form,
				    XtNshowDotFiles, pattern
				    && *pattern == '.', XtNshowDirs,
				    showdirs, XtNnumberRows, 15,
				    XtNpattern, pattern, XtNwidth, 200,
				    XtNheight, 350, XtNselectAction,
				    (*mode == 'r'
				     || *mode == 'R') ? "READ" : "WRITE",
				    XtNdefaultFile, fname, XtNfromVert,
				    label, NULL);
	if (dirname)
		FileNominatorSetDirectory(filenom, dirname);

	XtAddCallback(filenom, XtNcancelCallback, CancelFB, pshell);
	XtAddCallback(filenom, XtNselectCallback, SelectFB, pshell);
	fb_file = NULL;
	fb_cancel = 0;

	xpopup(pshell);
	XtSetKeyboardFocus(TopLevel, filenom);
	while (!fb_cancel && fb_file == NULL)
		dloop_once();
	XtDestroyWidget(pshell);
	XtSetKeyboardFocus(TopLevel, None);

	if (fb_cancel)
		return (NULL);
	else {
		if (*mode == 'a' && probefile(fb_file)) {
			if (strlen(fb_file) > 20 && *fb_file == '/')
				i = vpop_box("Overwrite", "Append",
					     "Cancel", "...%s exists",
					     rindex(fb_file, '/') + 1);
			else
				i = vpop_box("Overwrite", "Append",
					     "Cancel", "%s exists",
					     fb_file);
			if (i == 1 && unlink(fb_file) != 0) {
				alert("Can't unlink %s", fb_file);
				return (NULL);
			} else if (i == 3)
				return (NULL);
		} else if (*mode == 'w' && probefile(fb_file)) {
			if (strlen(fb_file) > 20 && *fb_file == '/')
				i = vpop_box("Overwrite", "Cancel", NULL,
					     "...%s exists",
					     rindex(fb_file, '/') + 1);
			else
				i = vpop_box("Overwrite", "Cancel", NULL,
					     "%s exists", fb_file);
			if (i != 1)
				return (NULL);
			if (unlink(fb_file) != 0) {
				alert("Can't unlink %s", fb_file);
				return (NULL);
			}
		}
		return (fb_file);
	}
}

char *fileBox(char *fname, char *mode, char *prompt)
{
	return (fileBoxMatch(fname, mode, prompt, GF_ALLFILES, GF_DIRS));
}

static void CancelFB_noblock(Widget w, XtPointer data_blah,
			     XtPointer call_data)
{
	struct noblock_data *data = (struct noblock_data *) data_blah;

	XtDestroyWidget(data->pshell);
	free(data);
}

static void SelectFB_noblock(Widget w, XtPointer data_blah,
			     XtPointer name_blah)
{
	struct noblock_data *data = (struct noblock_data *) data_blah;
	FileNominatorStruct *name = (FileNominatorStruct *) name_blah;
	char *p;

	p = (char *) malloc(strlen(name->directoryPart) +
			    strlen(name->filenamePart) + 1);
	strcpy(p, name->directoryPart);
	strcat(p, name->filenamePart);
	(*(data->cbfn)) (data->cbdata, p);
	free(p);
	if (data->once) {
		XtDestroyWidget(data->pshell);
		free(data);
	}
}

void fileBoxMatch_noblock(char *fname, char *mode, char *prompt,
			  char *pattern, int showdirs, void (*cbfn) (),
			  caddr_t cbdata, int once)
{
	Widget form, label, filenom;
	char *dirname;
	struct noblock_data *foo =
	    (struct noblock_data *) malloc(sizeof(struct noblock_data));

	if (*mode == 'w' || *mode == 'W' || *mode == 'a')
		foo->pshell = pop_new(TopLevel, "Write File");
	else
		foo->pshell = pop_new(TopLevel, "Read File");
	foo->cbfn = cbfn;
	foo->cbdata = cbdata;
	foo->once = once;

	if (*fname && fname[strlen(fname) - 1] == '/') {
		dirname = fname;
		fname = NULL;
	} else {
		dirname = NULL;
	}

	form = XtVaCreateManagedWidget("form",
				       formWidgetClass, foo->pshell, NULL);
	label = XtVaCreateManagedWidget("label", labelWidgetClass, form,
					XtNborderWidth, 0,
					XtNlabel, prompt, NULL);
	filenom = XtVaCreateManagedWidget("fileNominator",
					  fileNominatorWidgetClass, form,
					  XtNshowDotFiles, pattern
					  && *pattern == '.', XtNshowDirs,
					  showdirs, XtNnumberRows, 15,
					  XtNpattern, pattern, XtNwidth,
					  200, XtNheight, 350,
					  XtNselectAction, (*mode == 'r'
							    || *mode ==
							    'R') ? "READ" :
					  "WRITE", XtNcancelAction,
					  (once ==
					   GF_ONCE) ? "Cancel" : "Destroy",
					  XtNdefaultFile, fname,
					  XtNfromVert, label, NULL);
	if (dirname)
		FileNominatorSetDirectory(filenom, dirname);

	XtAddCallback(filenom, XtNcancelCallback, CancelFB_noblock, foo);
	XtAddCallback(filenom, XtNselectCallback, SelectFB_noblock, foo);
	popup_pointer(foo->pshell);
}
