/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: fd.h,v 1.27 2002/07/15 04:30:05 cmalek Exp $
** Program: xdphys
**  Module: fd.h
**  Author: mazer
** Descrip: fd.c header file
**
** Revision History (most recent last)
**  
** Thu Nov 12 12:40:06 1992 mazer
**  added filedata_read() etc
**
*******************************************************************/

#ifndef _FD_H_
#define _FD_H_

#include "svars.h"
#include "srl.h"

typedef struct file_data {
	char *filename;		/* where this data came from */
	char *progname;		/* program name (ie xdphys, xcalibur) */
	char *modname;		/* module name (ie itd, iid, abi, bf, ...) */
	SVAR_TABLE *params;	/* parameters from the header */
	char *comments;		/* user supplied comments */
	float ver_num;		/* dowl version as number */
	int *channels;		/* vector of channels containing data */

	void *rawdata;		/* ptr to module specific raw data */
	void *sumdata;		/* ptr to module specific summary data */

	int trashed;		/* don't use me anymore.. */
} FILEDATA;

#define fd_syn_spec_parse(spec,altf,s) \
			syn_spec_parse(((spec==NULL) || strcmp(spec,"hp")) ? \
			spec : "bp=4000-13000", altf, s);

#define VSM_ALL_CODE 1e9

#define PERHIST_DEF_NBINS 100
#define PERHIST_MP 0
#define PERHIST_VS 1
#define PERHIST_RT 2

#define TO_STDOUT	"-"
#define TO_POPUP	NULL

#define FD_GV(data, name) 	getvar(name, data->params)
#define FD_GVM(data, name, n)	getvar_match(name, data->params, n)
#define FD_GI(data, name) 	getvar_int(name, data->params)
#define FD_GF(data, name) 	getvar_float(name, data->params)

#define FD_SV(data, name, val) 	setvar(name, val, data->params)
#define FD_SI(data, name, val) 	setvar_int(name, val, data->params)
#define FD_SF(data, name, val) 	setvar_float(name, val, data->params)

extern void *getFDreadMethod(char *);
extern void *setFDreadMethod(char *, int (*)());
extern int doFDreadMethod(void *, FILEDATA *, int);

extern void *getFDfreeMethod(char *);
extern void *setFDfreeMethod(char *, int (*)());
extern int doFDfreeMethod(FILEDATA *);


extern void *getFDOplotMethod(char *);
extern void *setFDOplotMethod(char *, int (*)());
extern int doFDOplotMethod(void *, FILEDATA *, void *, int, FILE *);

extern void *getFDOdoplotMethod(char *);
extern void *setFDOdoplotMethod(char *, int (*)());
extern int doFDOdoplotMethod(void *, FILEDATA *, int, int, FILE *);

extern void *getFDOvalidviewMethod(char *);
extern void *setFDOvalidviewMethod(char *, int (*)());
extern int doFDOvalidviewMethod(void *, FILEDATA *, int);

extern FILEDATA *FD_read(char *, int);
extern void FD_free(FILEDATA *);
extern char *skipTo(FILE *, char *);

extern void FD_calc_params(FILEDATA *, int *, int *, float *, float *,
			   float *, float *);

extern SA_SpikeRasterList *FD_to_SpikeRasterList(int, spike_t **, int,
						 int);

extern void FD_perhist(int, spike_t **, float *, float, float, float *,
		       int, float **, float **, float **, float **, int **,
		       float *, float *, float *);
extern void FD_inverse_pres_order(int *, int **, int);
extern void FD_howmany_units(int **, int, spike_t **);
extern int FD_compare_intensities(float *, int, float *, int, float);
extern void FD_plotter_copy(float *, float *, float *, int, int,
			    float **, float **, float **, int *, float **,
			    float **, float **, int *);
extern void FD_combine_data(float *, float *, int, float *, float *, int,
			    float **, float **, int *);
extern void FD_peak_stats(int, int *, float **, float **, float *, char **,
			  int, int);
extern void funcs1(double, double *, int);
extern void funcs2(double, double[], double *, double[], int);
/*
extern void FD_linearity_stats(float*, float*, float*,
      float*, float**, int, int, void*, FILE*);
*/
extern void FD_perhist_compute_period_nbins(FILEDATA *, float *, int *);
extern void FD_vsm_menu(void *, int);
extern void FD_perhist1FN(void *, FILEDATA *, int, int, int *, spike_t **,
			  int *, float **, float **, int *, float *,
			  float *, float *, float, int, int);
extern void FD_perhist2FN(void *, FILEDATA *, int, int *, spike_t **,
			  int *, float **, float **, float **, float **,
			  int **, float *, float *, float *, float, int);

extern spike_t **FD_get_rastlist(FILEDATA *);
extern int FD_get_nrasters(FILEDATA *);
extern int *FD_get_pres_order(FILEDATA *);

#endif				/* _FD_H_ */
