/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: dynraster.h,v 2.45 2002/07/15 04:30:04 cmalek Exp $
** Program: dowl
**  Module: dynraster.h
**  Author: mazer
** Descrip: dynraster.c interface header
**
** Revision History (most recent last)
**
** Tue Apr  5 15:31:48 1994 mazer
**  creation date
**
*******************************************************************/

#ifndef _dynraster_h_

#define _dynraster_h_

typedef struct DynamicRaster {
	Widget r, xaxis, yaxis, spikes;
	int nlines, nextline;
	int ndata;
	float *xdata, *ydata;

	Widget marks;
	int nmarks;
	float *xmarks, *ymarks;
} DRASTER;

extern DRASTER *dynraster_new(Widget, Dimension, Dimension, int);
extern void dynraster_add(DRASTER *, int, spike_t *, int, int, int);
extern void dynraster_clear(DRASTER *);

#endif				/* _dynraster_h_ */
