/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: dock.h,v 2.45 2002/07/15 04:30:03 cmalek Exp $
** Program: dowl
**  Module: dock.h
**  Author: mazer
** Descrip: interface file for dock.c
**
** Revision History (most recent last)
**
*******************************************************************/

typedef struct {
	Widget dock;
	Widget psh;
	 Widget(*psh_maker) ();
	int popped;		/* really should be called realized */
} DockSlot;

typedef struct {
	Widget form;
	Widget fromvert;
	int maxslots;
	DockSlot *slots;
	int current;
} Dock;

extern Dock *dock_new(Widget, char *, int, Widget *);
extern int dock_add(Dock *, char *, Widget);
extern int dock_add_delayed(Dock *, char *, Widget(*)(DockSlot *));
extern Widget dock_nth(Dock *, int, int *);
extern Widget dockform_new(Widget, char *, int, Widget *, Widget *);
void popdown_dockslot(DockSlot *);
