/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: dock.c,v 2.49 2002/07/15 04:30:03 cmalek Exp $
** Program: dowl
**  Module: dock.c
**  Author: mazer
** Descrip: module dock code
**
** Revision History (most recent last)
**
** Sat Feb 15 18:38:23 1992 mazer
**  creation date
**
** Mon Mar  2 12:39:07 1992 mazer
**  added dock_launch() to allow launch by tool name
**
** Fri Nov 26 21:40:25 1993 mazer
**  added dock_nth()
**
** Wed Jan 26 23:55:06 1994 mazer
**  Added dock_add_delayed(), which is essentially late
**  binding for the dock entry's psh. Instead of specifying
**  a psh, you specify a function (i.e. promise) that builds
**  the psh on demain. The first time the dock's popped up
**  the function gets called to supply the required psh.
**  There's no real gain in cpu cycles (unless you never pop
**  the all the dockslots), but things "appear" load faster.
**
** Thu Aug 18 18:04:01 1994 mazer
**  added dockform_new()
**
** 97.12 bjarthur
**  fixed bug in the popuping up of dock slots such that they now popup
**  in the position they were last.
**
*******************************************************************/

#include "xdphyslib.h"

static void popup_dockslot(DockSlot *);
static void DockerCB(Widget, XtPointer, XtPointer);

static void popup_dockslot(DockSlot * slot)
{
	Position xpos, ypos;

	assert(!slot->popped);

	if (slot->psh == NULL) {
		assert(slot->psh_maker != NULL);
		slot->psh = (*(slot->psh_maker)) (slot);
		getGeometry(slot->psh, &xpos, &ypos);
		XtVaSetValues(slot->psh, XtNx, xpos, XtNy, ypos, NULL);
	}

	popup(slot->psh);
	slot->popped = 1;
}

void popdown_dockslot(DockSlot * slot)
{
	assert(slot->popped);

	popdown(slot->psh);
	slot->popped = 0;
}

static void DockerCB(Widget w, XtPointer a_slot_blah, XtPointer call_data)
{
	DockSlot *a_slot = (DockSlot *) a_slot_blah;
	Boolean state;

	XtVaGetValues(w, XtNstate, &state, NULL);
	if (state) {
		popup_dockslot(a_slot);
	} else {
		popdown_dockslot(a_slot);
	}
}

Dock *dock_new(Widget parent, char *name, int maxslots, Widget * formp)
{
	int i;
	Dock *d;
	Widget w;

	d = (Dock *) malloc(sizeof(Dock));
	d->maxslots = maxslots;
	d->slots = (DockSlot *) malloc(sizeof(DockSlot) * d->maxslots);
	d->form = form_new(parent, "dock", 1);
	d->current = -1;

	if (name)
		w = label_new(d->form, name, NULL, NULL, 0);	/* used to not have 0 */
	else
		w = NULL;
	d->fromvert = w;

	for (i = 0; i < d->maxslots; i++) {
		d->slots[i].dock = NULL;
		d->slots[i].psh = NULL;
	}

	if (formp != NULL)
		*formp = d->form;
	return (d);
}

int dock_add(Dock * d, char *txtlab, Widget psh)
{
	int i;
	Position xpos, ypos;

	for (i = 0; i < d->maxslots; i++) {
		if (d->slots[i].dock == NULL) {
			d->slots[i].dock =
			    toggle_new(d->form, txtlab, txtlab, NULL,
				       d->fromvert, NULL, DockerCB,
				       (XtPointer) (&d->slots[i]), False);
			XtVaSetValues(d->slots[i].dock, XtNwidth, 80,
				      XtNjustify, XtJustifyCenter, NULL);
			d->slots[i].psh = psh;
			d->slots[i].psh_maker = NULL;
			d->slots[i].popped = 0;
			d->fromvert = d->slots[i].dock;

			getGeometry(psh, &xpos, &ypos);
			XtVaSetValues(psh, XtNx, xpos, XtNy, ypos, NULL);

			return (i);
		}
	}
	XtAppError(XtWidgetToApplicationContext(TopLevel),
		   "dock_add: too many dock slots");
	return (-1);
}

int dock_add_delayed(Dock * d, char *txtlab,
		     Widget(*psh_maker) (DockSlot *))
{
	int i;

	for (i = 0; i < d->maxslots; i++) {
		if (d->slots[i].dock == NULL) {
			d->slots[i].dock =
			    toggle_new(d->form, txtlab, txtlab, NULL,
				       d->fromvert, NULL, DockerCB,
				       &d->slots[i], False);
			XtVaSetValues(d->slots[i].dock, XtNwidth, 80,
				      XtNjustify, XtJustifyCenter, NULL);
			d->slots[i].psh = NULL;
			d->slots[i].psh_maker = psh_maker;
			d->slots[i].popped = 0;
			d->fromvert = d->slots[i].dock;
			return (i);
		}
	}
	XtAppError(XtWidgetToApplicationContext(TopLevel),
		   "dock_add: too many dock slots");
	return (-1);
}

Widget dock_nth(Dock * d, int n, int *actual)
{
	int i;

	for (i = 0; i < d->maxslots; i++) {
		if (d->slots[i].dock == NULL) {
			if (n < 0 && i > 0) {
				i = i - 1;
			} else {
				i = 0;
			}
			break;
		} else if (i == n) {
			break;
		}
	}
	if (actual != NULL)
		*actual = i;
	return (d->slots[i].dock);
}

Widget dockform_new(Widget parent, char *title, int hider,
		    Widget * form_ptr, Widget * handle_ptr)
{
	Widget pshell, w, form;

	pshell = top_new(parent, title);
	form = XtVaCreateManagedWidget(title ? title : "dockform",
				       formWidgetClass, pshell, NULL);
	if (hider)
		w = button_new(form, "Hide", "Hide", HidePShellCB, pshell,
			       NULL, NULL);
	else
		w = NULL;

	if (title != NULL) {
		w = label_new(form, title, w, NULL, 0);
		ReverseColors(w);
	}
	if (form_ptr != NULL)
		*form_ptr = form;

	if (handle_ptr != NULL)
		*handle_ptr = w;

	return (pshell);
}
