/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: cutpaste.c,v 2.46 2002/07/15 04:30:02 cmalek Exp $
** Program: dowl
**  Module: cutpaste.c
**  Author: mazer
** Descrip: simple cut and paste via files..
**
** Revision History (most recent last)
**
** Sun Jan 30 15:31:56 1994 mazer
**  creation date
**
** Wed Feb  2 18:50:08 1994 mazer
**  fixed to actually use the x-selection mechanism
**
*******************************************************************/

#include "xdphyslib.h"

static Boolean get_selected_string(Widget, Atom *, Atom *, Atom *,
				   XtPointer *, unsigned long *, int *);
static void use_pasted_string(Widget, XtPointer, Atom *, Atom *, XtPointer,
			      unsigned long *, int *);

/*
 *	Called by the selection requestor.
 */
static Boolean get_selected_string(Widget w, Atom * sel, Atom * target,
				   Atom * type, XtPointer * value_blah,
				   unsigned long *length, int *fmt)
{
	char **value = (char **) value_blah;
	int tmp;

	if (*target == XA_STRING) {
		*type = XA_STRING;
		/* get the selected string string from the cut buffer */
		/* (we can use our own storage for this purpose) */
		*value = XFetchBytes(XtDisplay(w), &tmp);
		*length = tmp;
		*fmt = 8;
		return True;
	}
	return False;
}

/*
 *	Procedure (usually bound to the left mouse button) to
 *	commit the selection. This procedure is called from an
 *	event handler or action procedure.
 */
void AssignStringToPrimarySelection(Widget w, Time eventTime, char *string)
{
	unsigned long length = strlen(string);

	if (length > 0 && XtOwnSelection(w, XA_PRIMARY,
					 eventTime, get_selected_string,
					 /* was: clear_previous_selected_region, */
					 NULL, NULL))
		/* as said above we can use our own storage ... */
		XStoreBytes(XtDisplay(w), string, length);
}

/*
 *	Procedure called by the selection mechanism to use the "pasted" string.
 */
static void use_pasted_string(Widget w, XtPointer callback_fn_blah,
			      Atom * sel, Atom * type,
			      XtPointer value_blah, unsigned long *length,
			      int *fmt)
{
	void (*callback_fn) () = callback_fn_blah;
	char *value = (char *) value_blah;

	if (*type == XA_STRING) {
		(*callback_fn) (value);
	}
}

/*
 *	Procedure (usually bound to the middle mouse button) to
 *	retrieve the selection. This procedure is also called from
 *	an event handler or action procedure.
 *	Supply a callback_fn that takes the pair (string,length)
 *	to do something with the selection..
 */
void RetrievePrimarySelectionValue(Widget w, Time eventTime,
				   void (*callback_fn) ())
{
	XtGetSelectionValue(w, XA_PRIMARY, XA_STRING,
			    use_pasted_string, callback_fn, eventTime);
}
