/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: clock.h,v 2.44 2002/07/15 04:30:01 cmalek Exp $
** Program: dowl
**  Module: clock.h
**  Author: mazer
** Descrip: interface file for clock.c
**
** Revision History (most recent last)
**
*******************************************************************/

#define CLOCK_RESTART	1
#define CLOCK_STOP	0

#define CLOCK_USER	0
#define CLOCK_SYSTEM    1

struct clock_info {
	int running;		/* is clock running? */
	Widget w;		/* command widget for clock display */
	time_t startat;		/* time() clock was started */
	XtIntervalId timeout;	/* next update timeout */
	char *name;		/* name of clock (for alarm box) */
	char *opt_label;	/* name of clock (for clock label) */
	char *statefile;	/* statefile for this clock */
	SVAR_TABLE *svartable;	/* possibly private clock_svar_table */
	int clktype;		/* SYSTEM or USER clock */
	int interval;		/* update interval in ms */
	int alarm_time;		/* alarm time in secs */
	int alarm_trigd;	/* set when alarm is triggered */
	XtIntervalId led_timeout;	/* next led blink timeout */
	int led_state;		/* current led state */
	char last_buf[50];	/* buffer for last string displayed.. */
};

extern void clock_reset(struct clock_info *, int);
extern int clock_read(struct clock_info *, int *, int *, int *);
extern Widget clock_new(Widget, char *, Widget, Widget, char *,
			SVAR_TABLE *, int, void **, char *, int, int);
