/******************************************************************
** Program: xdphys
** File:    autolog.c
** Author:  cmalek@caltech.edu (Chris Malek)
** RCSid: $Id: autolog.c,v 2.1 2002/07/15 04:30:00 cmalek Exp $
** Description: 
**
** This file contains functions related to the log file.
**
*******************************************************************/

#include "stdio.h"
#include "stdlib.h"
#include "xdphyslib.h"

/* ---------------------------------------------------------------------- */
/* Prototypes                                                             */
/* ---------------------------------------------------------------------- */

/* ---------------------------------------------------------------------- */
/* Global variables                                                       */
/* ---------------------------------------------------------------------- */

/* ---------------------------------------------------------------------- */
/* Local Functions                                                        */
/* ---------------------------------------------------------------------- */
static void delimit_log_entry(FILE * fp)
{
	int d;

	for (d = 70; d >= 0; d--) {
		fputs(d ? "-" : "-\n", fp);
	}
}

/* ---------------------------------------------------------------------- */
/* Public Functions                                                       */
/* ---------------------------------------------------------------------- */

void append_to_log(int run_type, char *filename, char *suffix, char *message)
{
	FILE *fp;
	char *comments;

	if ((fp = fopen2(AUTOLOG, "a")) != NULL) {
		delimit_log_entry(fp);
		fprintf(fp, "%s\n** file \"%s\" [type=%s] %s\n",
			GS("time"), basename(filename), suffix, message);
		comments = possibly_get_comments(run_type, filename);
		if (GI("Comments") && comments) {
			fputs(comments, fp);
		}
		fclose(fp);
	}
}

/* ---------------------------------------------------------------------- */
void LogView(Widget w, XtPointer client_data, XtPointer call_data)
{
	if (probefile(AUTOLOG))
		pop_file_at("LogView", AUTOLOG, 1);
	else
		notify("Can't open \"%s\"", AUTOLOG);
}

/* ---------------------------------------------------------------------- */
/* LogEntry                                                               */
/*                                                                        */
/* The difference between this and append_to_log() is that this is a      */
/* freeform log written by a human, as opposed to an automatically        */
/* generated message from xdphys.  Thus it doesn't have as strict a form. */
/*                                                                        */
/* Probably should extract the shared code from this and append_to_log    */
/* at some point.                                                         */
/* ---------------------------------------------------------------------- */
void LogEntry(Widget w, XtPointer client_data, XtPointer call_data)
{
	char logbuf[1000];
	char *p;
	FILE *logfp;

	sprintf(logbuf, "%s :: LOG ENTRY\n", GS("time"));
	if ((p =
	     pop_text("Log Entry", logbuf, sizeof(logbuf) - 1,
		      1)) != NULL) {
		if (logbuf[strlen(logbuf) - 1] != '\n')
			strcat(logbuf, "\n");
		if ((logfp = fopen2(AUTOLOG, "a")) != NULL) {
			delimit_log_entry(logfp);
			fputs(p, logfp);
			fclose(logfp);
		} else {
			alert("Can't open logfile: %s", AUTOLOG);
		}
	}
}

