/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: atmisc.c,v 2.46 2002/07/15 04:30:00 cmalek Exp $
** Program: dowl
**  Module: atmisc.c
**  Author: mazer
** Descrip: misc utility functions for atplotter widgets..
**
** Revision History (most recent last)
**
** Sun Jun 27 19:56:57 1993 mazer
**  created
**
*******************************************************************/

#include "xdphyslib.h"

void AtMisc_XZoomCB(Widget w, Widget xaxis,
		    AtRectangleCallbackData * atrect)
{
	if (atrect->x11 < atrect->x12)
		XtVaSetValues(xaxis, XtNmin, &atrect->x11, XtNmax,
			      &atrect->x12, XtNautoScale, False, NULL);
	else
		XtVaSetValues(xaxis, XtNmax, &atrect->x11, XtNmin,
			      &atrect->x12, XtNautoScale, False, NULL);
}

void AtMisc_YZoomCB(Widget w, Widget yaxis,
		    AtRectangleCallbackData * atrect)
{
	if (atrect->y11 < atrect->y12)
		XtVaSetValues(yaxis, XtNmin, &atrect->y11, XtNmax,
			      &atrect->y12, XtNautoScale, False, NULL);
	else
		XtVaSetValues(yaxis, XtNmax, &atrect->y11, XtNmin,
			      &atrect->y12, XtNautoScale, False, NULL);
}

void AtMisc_UnzoomCB(Widget w, Widget axis, caddr_t call_data)
{
	XtVaSetValues(axis, XtNautoScale, True, NULL);
}

void AtMisc_TogLegendCB(Widget w, Widget plotter, caddr_t call_data)
{
	Boolean b;

	XtVaGetValues(plotter, XtNshowLegend, &b, NULL);
	b = !b;
	XtVaSetValues(plotter, XtNshowLegend, b, NULL);
}
