/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: WaveP.h,v 2.44 2002/07/15 04:29:59 cmalek Exp $
** Program: dowl
**  Module: WaveP.h
**  Author: mazer
** Descrip: private WaveWidget interface
**
** Revision History (most recent last)
**
*******************************************************************/

#ifndef _WaveP_h
#define _WaveP_h

typedef struct {
	int empty;
} WaveClassPart;

typedef struct _WaveClassRec {
	CoreClassPart core_class;
	WaveClassPart wave_class;
} WaveClassRec;

extern WaveClassRec waveClassRec;

typedef struct _WaveState {
	int begin, end;
	struct _WaveState *next;
} WaveState;

typedef struct {
	/*
	 ** natural resources
	 */
	XtCallbackList input_callback;
	Boolean use_lines;
	Boolean show_grid;
	Boolean auto_scale;
	Boolean auto_range;
	Pixel foreground_pixel;
	Pixel gridcolor_pixel;
	int wave_begin;
	int wave_end;
	Boolean display_info;
	Boolean show_y_axis;
	Boolean show_x_axis;
	Boolean user_cursors;
	int cursor1;
	int cursor2;
	int hcursor1;
	int hcursor2;
	Boolean show_h_cursor2;
	Boolean show_h_cursor1;
	int fc;
	String fontname;	/* name of font to use */
	XFontStruct *fontinfo;	/* font for text */

	/*
	 ** privates
	 */
	xword *waveform;	/* set with XtWaveSetWaveform() */
	int npoints;
	int ymin, ymax;
	GC gc;			/* internal gc (for waveform) */
	GC grid_gc;		/* internal gc (for grid only) */
	int data_min, data_max;
	WaveState *xzoomstack;
	Window msgwin;
	WaveWidget link_to;
	int link_hit;
} WavePart;

typedef struct _WaveRec {
	CorePart core;
	WavePart wave;
} WaveRec;

#define XtCUseLines	"UseLines"
#define XtCAutoScale	"AutoScale"
#define XtCAutoRange	"AutoRange"
#define XtCGridColor 	"GridColor"
#define XtCShowGrid 	"ShowGrid"
#define XtCWavePosition "WavePosition"
#define XtCFc		"Fc"
#define XtCDisplayInfo	"DisplayInfo"
#define XtCAxisView	"AxisView"
#define XtCCursorView	"CursorView"

#endif				/* _WaveP_h */
