/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: Wave.h,v 2.44 2002/07/15 04:29:59 cmalek Exp $
** Program: dowl
**  Module: Wave.h
**  Author: mazer
** Descrip: public WaveWidget interface
**
** Revision History (most recent last)
**
** Sun Jan 31 21:51:42 1993 mazer
**  renamed psWave() to XtWavePS() and made public
**
*******************************************************************/


#ifndef _Wave_h
#define _Wave_h

/****************************************************************
 *
 * Wave widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
From Template:
------------------------------------------------------------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

New to Wave:
------------------------------------------------------------------
 callback	     Callback		Callback	NULL
 useLines	     UseLines		Boolean		False
 showGrid	     ShowGrid		Boolean		False
 autoScale	     AutoScale		Int		0
   NOTE: autoscale == 0 -> no scaling
   NOTE: autoscale == 1 -> scale to fit entire waveform
   NOTE: autoscale == 2 -> scale to fit visible portion
 autoRange	     AutoRange		Boolean		False
   NOTE: autoranging keeps waveform centered..
 foreground	     Foreground		Pixel		XtDefaultForeground
 gridcolor	     Gridcolor		Pixel		XtDefaultForeground
 waveBegin	     WavePosition	Int		-1
 waveEnd	     WavePosition	Int		-1
 userCursors	     Sensitive		Boolean		False
 cursor1	     WavePosition	Int		-1
 cursor2	     WavePosition	Int		-1
 horizCursor1	     WavePosition	Int		0
 horizCursor2	     WavePosition	Int		0
 showHorizCursor1     CursorView		Boolean		False
 showHorizCursor2     CursorView		Boolean		False
 fc		     Int		Int		-1
 displayInfo	     DisplayInfo	Boolean		True
 showYaxis	     AxisView		Boolean		False
 showxaxis	     AxisView		Boolean		False

*/

typedef struct _WaveClassRec *WaveWidgetClass;
typedef struct _WaveRec *WaveWidget;
extern WidgetClass waveWidgetClass;

extern int XtWaveEventPosition(WaveWidget, XEvent *);
extern void XtWavePS(WaveWidget, char *, char *);
extern void XtWaveSetWaveform(WaveWidget, xword *, int, int, int, int);
extern void XtWaveSetWaveformOffset(WaveWidget, xword *, int, int, int,
				    int, int);
extern void XtWaveLink(WaveWidget, WaveWidget, int);

#define XtNuseLines 	"useLines"
#define XtNgridColor 	"gridColor"
#define XtNshowGrid 	"showGrid"
#define XtNautoScale	"autoScale"
#define XtNautoRange	"autoRange"

#define XtNwaveBegin	"waveBegin"
#define XtNwaveEnd	"waveEnd"
#define XtNuserCursors  "userCursors"
#define XtNdisplayInfo  "displayInfo"

#define XtNcursor1	"cursor1"
#define XtNcursor2	"cursor2"

#define XtNshowHorizCursor1	"showHorizCursors1"
#define XtNhorizCursor1		"horizCursor1"
#define XtNshowHorizCursor2	"showHorizCursors2"
#define XtNhorizCursor2		"horizCursor2"

#define XtNshowYaxis	"showYaxis"
#define XtNshowXaxis	"showXaxis"

#define XtNfc		"fc"

#endif				/* _Wave_h */
