/******************************************************************
**  RCSID: $Id: FileNom.c,v 2.49 2002/07/15 04:29:57 cmalek Exp $
** Program: xdowl
**  Module: FileNom.c
**  Author: mazer
** Descrip: public domain file selector widget
**
**   >>> NOTE: Original copyright notice at end of file <<<
**
** Revision History (most recent last)
**
** Fri Nov 26 16:59:05 1993 mazer
**  added simple completion and "cleaned up" code blocking..
**
*******************************************************************/

#include "xdphyslib.h"
#include "FileNom.h"
#include "FileNomP.h"

#ifndef __linux__
#define dirent direct
#endif				/* __linux__ */

extern int scandir();
extern char *getenv();
extern char *getwd();

#define offset(field) XtOffsetOf(FileNominatorRec, fileNominator.field)

static XtResource resources[] = {
	{XtNselectCallback, XtCCallback, XtRCallback,
	 sizeof(XtCallbackList),
	 offset(select_callback), XtRCallback, (XtPointer) NULL}
	,
	{XtNselectMenu, XtCSelectMenu, XtRString, sizeof(String),
	 offset(select_menu), XtRString, (XtPointer) NULL}
	,
	{XtNcancelCallback, XtCCallback, XtRCallback,
	 sizeof(XtCallbackList),
	 offset(cancel_callback), XtRCallback, (XtPointer) NULL}
	,
	{XtNmargin, XtCMargin, XtRDimension, sizeof(Dimension),
	 offset(margin), XtRImmediate, (XtPointer) 10}
	,
	{XtNnumberRows, XtCNumberStrings, XtRInt, sizeof(int),
	 offset(number_rows), XtRImmediate, (XtPointer) 12},
	{XtNshowDotFiles, XtCShowDotFiles, XtRBoolean, sizeof(Boolean),
	 offset(show_dot_files), XtRImmediate, (XtPointer) True}
	,
	{XtNshowDirs, XtCShowDirs, XtRBoolean, sizeof(Boolean),
	 offset(show_dirs), XtRImmediate, (XtPointer) True}
	,
	{XtNbellLevel, XtCBellLevel, XtRInt, sizeof(int),
	 offset(bell_level), XtRImmediate, (XtPointer) 100},
	{XtNpattern, XtCPattern, XtRString, sizeof(String),
	 offset(pattern), XtRString, (XtPointer) NULL}
	,
	{XtNdefaultFile, XtCDefaultFile, XtRString, sizeof(String),
	 offset(default_file), XtRString, (XtPointer) NULL}
	,
	{XtNselectAction, XtCSelectAction, XtRString, sizeof(String),
	 offset(select_action), XtRString, (XtPointer) "select"}
	,
	{XtNcancelAction, XtCCancelAction, XtRString, sizeof(String),
	 offset(cancel_action), XtRString, (XtPointer) "cancel"}
	,
	{XtNannotateMethod, XtCFunction, XtRFunction, sizeof(XtPointer),
	 offset(annotate_method), XtRFunction, (XtPointer) NULL}
	,
};

#undef offset

#ifdef __STDC__
#define Child(w,child) \
	(((FileNominatorWidget) w)->fileNominator.child##_widget)
#else
#define Child(w,child) \
	(((FileNominatorWidget) w)->fileNominator.child/**/_widget)
#endif
#define List(w) (((FileNominatorWidget) w)->fileNominator.listList)
#define Rows(w) (((FileNominatorWidget) w)->fileNominator.number_rows)
#define CurrentDir(w) (((FileNominatorWidget) w)->fileNominator.currentDir)
#define WatchingChanges(w) \
	(((FileNominatorWidget) w)->fileNominator.watchingChanges)
#define Nomination(w) (((FileNominatorWidget) w)->fileNominator.nomination)
#define ShowDotFiles(w) \
	(((FileNominatorWidget) w)->fileNominator.show_dot_files)
#define ShowDirs(w) (((FileNominatorWidget) w)->fileNominator.show_dirs)
#define BellLevel(w) (((FileNominatorWidget) w)->fileNominator.bell_level)
#define Pattern(w) (((FileNominatorWidget) w)->fileNominator.pattern)
#define DefaultFile(w) (((FileNominatorWidget) w)->fileNominator.default_file)
#define SelectAction(w) \
	(((FileNominatorWidget) w)->fileNominator.select_action)
#define CancelAction(w) \
	(((FileNominatorWidget) w)->fileNominator.cancel_action)
#define AnnotateMethod(w) \
	(((FileNominatorWidget) w)->fileNominator.annotate_method)

static char pathTranslations[] =
    "<BtnDown>:reset() MakeMenu() XawPositionSimpleMenu(menu) MenuPopup(menu)";

static char listTranslations[] =
    "<Btn1Up>(2):         Set() Nominate() Unset()\n\
     <Btn1Down>,<Btn1Up>: Set() Notify() \n\
     <Btn2Up>:            Set() Notify() Nominate() Unset()";

static char filenameTranslations[] = "<Key>Return: 	Nominate()	\n\
      <Key>KP_Enter: 	Nominate() 	\n\
      <Key>Escape: 	Cancel() 	\n\
      <Key>Tab: 	Complete() 	\n\
      Meta<Key>D: 	DotFiles()\n";

static char selectTranslations[] = "<Btn1Up>: Nominate() unset()";

static char selectMenuTranslations[] =
    "<Btn3Down>: XawPositionSimpleMenu(selectMenu) MenuPopup(selectMenu)";

static void MakeMenu(), Nominate(), DotFiles(), Cancel(), Complete();

static XtActionsRec pathActions[] = {
	{"MakeMenu", MakeMenu},
	{"Nominate", Nominate},
	{"DotFiles", DotFiles},
	{"Cancel", Cancel},
	{"Complete", Complete},
};

static void CancelCallback(Widget, XtPointer, XtPointer);
static void ChangeDirectory(FileNominatorWidget, int);
static void SelectDir(Widget, XtPointer, XtPointer);
static void FillWindow(Widget);
static void ReplaceFilename(Widget, XtPointer, XtPointer);
static void AsciiSourceChanged(Widget, XtPointer, XtPointer);
static void WatchForChanges(Widget);
static void DontWatchForChanges(Widget);
static void CollapsePath(char *, char *);

static void Initialize(Widget, Widget, ArgList, Cardinal *);
static void PositionChildren(FileNominatorWidget);
static void Realize(Widget, XtValueMask *, XSetWindowAttributes *);
static void Destroy(Widget);

static void CalculateSize(FileNominatorWidget, Dimension *, Dimension *);

FileNominatorClassRec fileNominatorClassRec = {
	{
    /*** Core class part ***/
	 /* superclass            */ (WidgetClass) & widgetClassRec,
	 /* class_name            */ "FileNominator",
	 /* widget_size           */ sizeof(FileNominatorRec),
	 /* class_initialize      */ NULL,
	 /* class_part_initialize */ NULL,
	 /* class_inited          */ FALSE,
	 /* initialize            */ Initialize,
	 /* initialize_hook       */ NULL,
	 /* realize               */ Realize,
	 /* actions               */ NULL,
	 /* num_actions           */ 0,
	 /* resources             */ resources,
	 /* num_resources         */ XtNumber(resources),
	 /* xrm_class             */ NULLQUARK,
	 /* compress_motion       */ TRUE,
	 /* compress_exposure     */ XtExposeCompressMultiple,
	 /* compress_enterleave   */ TRUE,
	 /* visible_interest      */ FALSE,
	 /* destroy               */ Destroy,
	 /* resize                */ PositionChildren,
	 /* expose                */ NULL,
	 /* set_values            */ NULL,
	 /* set_values_hook       */ NULL,
	 /* set_values_almost     */ XtInheritSetValuesAlmost,
	 /* get_values_hook       */ NULL,
	 /* accept_focus          */ NULL,
	 /* version               */ XtVersion,
	 /* callback offsets      */ NULL,
	 /* tm_table              */ NULL,
	 /* query_geometry        */ XtInheritQueryGeometry,
	 /* display_accelerator   */ NULL,
	 /* extension             */ NULL,
	 }
	,
	{
    /*** FileNominator class part ***/
	 /* extension             */ NULL,
	 }
};

WidgetClass fileNominatorWidgetClass =
    (WidgetClass) & fileNominatorClassRec;

static void CalculateSize(FileNominatorWidget, Dimension *, Dimension *);
static void DestroyMenu(Widget, XtPointer, XtPointer);
static void MakeMenu(Widget, XEvent *, String *, Cardinal *);
static void ChangeDir(Widget, XtPointer, XtPointer);
static void Nominate(Widget, XEvent *, String *, Cardinal *);
static void Cancel(Widget, XEvent *, String *, Cardinal *);
static void Complete(Widget, XEvent *, String *, Cardinal *);
static void DotFiles(Widget, XEvent *, String *, Cardinal *);


static void CalculateSize(FileNominatorWidget fnw, Dimension * width,
			  Dimension * height)
{
	int max;
	int file_width = Child(fnw, filename)->core.width +
	    2 * Child(fnw, filename)->core.border_width;
	int select_width = Child(fnw, select)->core.width +
	    2 * Child(fnw,
		      select)->core.border_width +
	    fnw->fileNominator.margin + Child(fnw,
					      cancel)->core.width +
	    2 * Child(fnw, cancel)->core.border_width + Child(fnw,
							      path)->core.
	    width + 2 * Child(fnw,
			      path)->core.border_width +
	    fnw->fileNominator.margin;

	if (fnw->fileNominator.margin == 0) {
		max =
		    select_width -
		    4 * (Child(fnw, select)->core.border_width) >
		    file_width - 2 * Child(fnw,
					   filename)->core.
		    border_width ? select_width -
		    4 *
		    (Child(fnw, select)->core.border_width) : file_width -
		    2 * Child(fnw, filename)->core.border_width;
	} else {
		max =
		    select_width > file_width ? select_width : file_width;
	}

	if (*width == 0) {
		/* if a width was not specified, calc from max, else use it.. */
		*width = max + 2 * fnw->fileNominator.margin;
	}
	*height = Child(fnw, viewport)->core.height +
	    Child(fnw, filename)->core.height +
	    Child(fnw, select)->core.height +
	    4 * fnw->fileNominator.margin;

	if (fnw->fileNominator.margin == 0) {
		*height += 2 * (Child(fnw, filename)->core.border_width);
	} else {
		*height += 2 * (Child(fnw, filename)->core.border_width +
				Child(fnw, viewport)->core.border_width +
				Child(fnw, select)->core.border_width);
	}
}


static void PositionChildren(FileNominatorWidget fnw)
{
	if (fnw->fileNominator.margin == 0) {
		XtConfigureWidget(Child(fnw, viewport),
				  0, 0,
				  fnw->core.width,
				  fnw->core.height -
				  Child(fnw, filename)->core.height -
				  2 * Child(fnw,
					    filename)->core.border_width -
				  Child(fnw, select)->core.height, 0);
	} else {
		XtConfigureWidget(Child(fnw, viewport),
				  fnw->fileNominator.margin,
				  fnw->fileNominator.margin,
				  fnw->core.width -
				  2 * fnw->fileNominator.margin -
				  2 * Child(fnw,
					    viewport)->core.border_width,
				  fnw->core.height - 2 * Child(fnw,
							       viewport)->
				  core.border_width - Child(fnw,
							    filename)->
				  core.height - 2 * Child(fnw,
							  filename)->core.
				  border_width - Child(fnw,
						       select)->core.
				  height - 2 * Child(fnw,
						     select)->core.
				  border_width -
				  4 * fnw->fileNominator.margin, Child(fnw,
								       viewport)->
				  core.border_width);
	}

	if (fnw->fileNominator.margin == 0) {
		XtConfigureWidget(Child(fnw, filename),
				  -(Child(fnw, filename)->core.
				    border_width), Child(fnw,
							 viewport)->core.
				  height, fnw->core.width, Child(fnw,
								 filename)->
				  core.height, Child(fnw,
						     filename)->core.
				  border_width);
	} else {
		XtConfigureWidget(Child(fnw, filename),
				  fnw->fileNominator.margin,
				  fnw->core.height - Child(fnw,
							   select)->core.
				  height - 2 * Child(fnw,
						     select)->core.
				  border_width - Child(fnw,
						       filename)->core.
				  height - 2 * Child(fnw,
						     filename)->core.
				  border_width -
				  2 * fnw->fileNominator.margin,
				  fnw->core.width -
				  2 * fnw->fileNominator.margin -
				  2 * Child(fnw,
					    filename)->core.border_width,
				  Child(fnw, filename)->core.height,
				  Child(fnw, filename)->core.border_width);
	}

	if (fnw->fileNominator.margin == 0) {
		XtMoveWidget(Child(fnw, select), -1,
			     fnw->core.height -
			     Child(fnw, select)->core.height - 1);
	} else {
		XtMoveWidget(Child(fnw, select), fnw->fileNominator.margin,
			     fnw->core.height -
			     fnw->fileNominator.margin -
			     2 * Child(fnw, select)->core.border_width -
			     Child(fnw, select)->core.height);
	}


	if (fnw->fileNominator.margin == 0) {
		XtMoveWidget(Child(fnw, path),
			     Child(fnw, select)->core.width,
			     fnw->core.height -
			     Child(fnw, select)->core.height - 1);
	} else {
		XtMoveWidget(Child(fnw, path),
			     Child(fnw, select)->core.width +
			     2 * Child(fnw, select)->core.border_width +
			     2 * fnw->fileNominator.margin,
			     fnw->core.height -
			     fnw->fileNominator.margin -
			     2 * Child(fnw, select)->core.border_width -
			     Child(fnw, select)->core.height);
	}

	if (fnw->fileNominator.margin == 0) {
		XtMoveWidget(Child(fnw, cancel),
			     Child(fnw, select)->core.width +
			     Child(fnw, path)->core.width +
			     Child(fnw, select)->core.border_width,
			     fnw->core.height -
			     Child(fnw, select)->core.height - 1);
	} else {
		XtMoveWidget(Child(fnw, cancel),
			     Child(fnw, path)->core.width +
			     2 * Child(fnw, path)->core.border_width +
			     Child(fnw, select)->core.width +
			     2 * Child(fnw, select)->core.border_width +
			     3 * fnw->fileNominator.margin,
			     fnw->core.height -
			     fnw->fileNominator.margin -
			     2 * Child(fnw, select)->core.border_width -
			     Child(fnw, select)->core.height);
	}
}

static void Initialize(Widget req, Widget new, ArgList args,
		       Cardinal * num_args)
{
	FileNominatorWidget fnw = (FileNominatorWidget) new;
	Widget sMenu, menuEntry;
	String menuList, p, q;

	List(new) = NULL;
	Nomination(new).directoryPart = NULL;
	Nomination(new).filenamePart = NULL;

	(void) getcwd(CurrentDir(new), MAXPATHLEN);

	if (CurrentDir(new)[strlen(CurrentDir(new)) - 1] != '/') {
		strcat(CurrentDir(new), "/");
	}
	WatchingChanges(new) = False;

	Child(fnw, viewport) =
	    XtVaCreateWidget("viewport", viewportWidgetClass, new,
			     XtNallowVert, True, NULL);

	Child(fnw, list) =
	    XtVaCreateManagedWidget("list", listWidgetClass,
				    Child(fnw, viewport),
				    XtNdefaultColumns, 1, XtNforceColumns,
				    True, NULL);
	XtOverrideTranslations(Child(fnw, list),
			       XtParseTranslationTable(listTranslations));
	XtAddCallback(Child(fnw, list), XtNcallback, ReplaceFilename,
		      NULL);
	FillWindow(fnw);

	if (DefaultFile(new) != NULL) {
		Child(fnw, filename) =
		    XtVaCreateWidget("filename", asciiTextWidgetClass, new,
				     XtNeditType, XawtextEdit,
				     XtNstring, DefaultFile(new), NULL);
	} else {
		Child(fnw, filename) =
		    XtVaCreateWidget("filename", asciiTextWidgetClass, new,
				     XtNeditType, XawtextEdit, NULL);
	}

	XtOverrideTranslations(Child(fnw, filename),
			       XtParseTranslationTable
			       (filenameTranslations));

	XtSetKeyboardFocus(new, Child(fnw, filename));
	WatchForChanges(fnw);

	Child(fnw, select) =
	    XtVaCreateWidget(SelectAction(fnw), commandWidgetClass, new,
			     NULL);
	XtOverrideTranslations(Child(fnw, select),
			       XtParseTranslationTable
			       (selectTranslations));

	if ((p = getenv("SELECTMENU")) != NULL
	    || fnw->fileNominator.select_menu) {
		sMenu =
		    XtVaCreatePopupShell("selectMenu",
					 simpleMenuWidgetClass, Child(fnw,
								      select),
					 NULL);
		if (p != NULL) {
			menuList = XtNewString(p);
			p = menuList;
			for (p = menuList; (q = index(p, ' ')); p = q + 1) {
				*q = '\0';
				menuEntry =
				    XtVaCreateManagedWidget(p,
							    smeBSBObjectClass,
							    sMenu, NULL);
				XtAddCallback(menuEntry, XtNcallback,
					      SelectDir, NULL);
			}
			XtFree(menuList);
		}
		if (fnw->fileNominator.select_menu != NULL) {
			menuList =
			    XtNewString(fnw->fileNominator.select_menu);
			p = menuList;
			for (p = menuList; (q = index(p, ':')); p = q + 1) {
				*q = '\0';
				menuEntry =
				    XtVaCreateManagedWidget(p,
							    smeBSBObjectClass,
							    sMenu, NULL);
				XtAddCallback(menuEntry, XtNcallback,
					      SelectDir, NULL);
			}
		}
		menuEntry =
		    XtVaCreateManagedWidget(p, smeBSBObjectClass, sMenu,
					    NULL);
		XtAddCallback(menuEntry, XtNcallback, SelectDir, NULL);
		XtVaSetValues(sMenu, XtNpopupOnEntry, menuEntry, NULL);

		XtOverrideTranslations(Child(fnw, select),
				       XtParseTranslationTable
				       (selectMenuTranslations));
		XtFree(menuList);
	}

	Child(fnw, path) =
	    XtVaCreateWidget("path", menuButtonWidgetClass, new, NULL);
	XtOverrideTranslations(Child(fnw, path),
			       XtParseTranslationTable(pathTranslations));
	XtAppAddActions(XtWidgetToApplicationContext(new),
			pathActions, XtNumber(pathActions));
	XawSimpleMenuAddGlobalActions(XtWidgetToApplicationContext(new));

	Child(fnw, cancel) =
	    XtVaCreateWidget(CancelAction(fnw), commandWidgetClass, new,
			     NULL);
	XtAddCallback(Child(fnw, cancel), XtNcallback, CancelCallback,
		      NULL);

	CalculateSize(fnw, &fnw->core.width, &fnw->core.height);
	PositionChildren(fnw);
}

static void Realize(Widget w, XtValueMask * valueMask,
		    XSetWindowAttributes * attributes)
{
	(*fileNominatorWidgetClass->core_class.superclass->core_class.
	 realize)
	    (w, valueMask, attributes);

	XtRealizeWidget(Child(w, viewport));
	XtRealizeWidget(Child(w, list));
	XtRealizeWidget(Child(w, filename));
	XtRealizeWidget(Child(w, select));
	XtRealizeWidget(Child(w, path));
	XtRealizeWidget(Child(w, cancel));

	XMapSubwindows(XtDisplay(w), XtWindow(w));
}

static void Destroy(Widget w)
{
	int idx;
	FileNominatorWidget fnw = (FileNominatorWidget) w;

	XtDestroyWidget(Child(fnw, list));
	XtDestroyWidget(Child(fnw, viewport));
	XtDestroyWidget(Child(fnw, filename));
	XtDestroyWidget(Child(fnw, select));
	XtDestroyWidget(Child(fnw, path));
	XtDestroyWidget(Child(fnw, cancel));

	idx = 0;
	while (List(fnw)[idx]) {
		XtFree(List(fnw)[idx++]);
	}
	XtFree(List(fnw)[idx]);
	XtFree(List(fnw));

	XtFree(Nomination(fnw).directoryPart);
	XtFree(Nomination(fnw).filenamePart);
}

static void CancelCallback(Widget w, XtPointer client_data,
			   XtPointer call_data)
{
	XtCallCallbacks(XtParent(w), XtNcancelCallback, NULL);
}

static void DestroyMenu(Widget w, XtPointer client_data,
			XtPointer call_data)
{
	XtDestroyWidget(w);
}

static void MakeMenu(Widget w, XEvent * event, String * params,
		     Cardinal * num_params)
{
	FileNominatorWidget fnw = (FileNominatorWidget) XtParent(w);
	String menuName;
	Widget menu, menuEntry;
	char *where, *p1, *p2;
	int menuItem = 1, len;

	XtVaGetValues(w, XtNmenuName, &menuName, NULL);

	menu =
	    XtVaCreatePopupShell(menuName, simpleMenuWidgetClass, w, NULL);
	XtAddCallback(menu, XtNpopdownCallback, DestroyMenu, NULL);

	where = XtNewString(CurrentDir(fnw));
	menuEntry =
	    XtVaCreateManagedWidget("/", smeBSBObjectClass, menu, NULL);
	XtAddCallback(menuEntry, XtNcallback, ChangeDir,
		      (XtPointer) menuItem++);
	p1 = where + 1;
	len = strlen(where);
	while (p1 < &where[len]) {
		if (!(p2 = index(p1, '/'))) {
			p2 = &where[len];
		}
		*p2 = '\0';
		menuEntry =
		    XtVaCreateManagedWidget(p1, smeBSBObjectClass, menu,
					    NULL);
		XtAddCallback(menuEntry, XtNcallback, ChangeDir,
			      (XtPointer) menuItem++);
		p1 = p2 + 1;
	}

	XtVaSetValues(menu, XtNpopupOnEntry, menuEntry, NULL);
	XtFree(where);
}

static void ChangeDirectory(FileNominatorWidget fnw, int position)
{
	String p;
	int m;

	if (position > 0) {
		p = CurrentDir(fnw);
		for (m = 0; m < position; ++m) {
			while (*p++ != '/');
		}
		*p = '\0';
	}

	XtVaSetValues(Child(fnw, filename), XtNstring, "", NULL);
	FillWindow(fnw);
	PositionChildren(fnw);
}

static void ChangeDir(Widget w, XtPointer client_data, XtPointer call_data)
{
	FileNominatorWidget fnw =
	    (FileNominatorWidget) XtParent(XtParent(XtParent(w)));

	ChangeDirectory(fnw, (int) client_data);
}

static void SelectDir(Widget w, XtPointer client_data, XtPointer call_data)
{
	FileNominatorWidget fnw
	    = (FileNominatorWidget) XtParent(XtParent(XtParent(w)));
	String label;

	XtVaGetValues(w, XtNlabel, &label, NULL);

	XtVaSetValues(Child(fnw, filename), XtNstring, label, NULL);

	Nominate(Child(fnw, select), NULL, NULL, NULL);
}

static void Nominate(Widget w, XEvent * event, String * params,
		     Cardinal * num_params)
{
	FileNominatorWidget fnw;
	char *nomination, *home, selection[MAXPATHLEN], *newPath, *r;
	struct stat fstats;
	int status, len;

	if (XtIsSubclass(w, listWidgetClass)) {
		fnw = (FileNominatorWidget) XtParent(XtParent(w));
	} else {
		fnw = (FileNominatorWidget) XtParent(w);
	}

	XtVaGetValues(Child(fnw, filename), XtNstring, &nomination, NULL);

	selection[0] = '\0';
	if (*nomination == '/') {
		strcpy(selection, nomination);
	} else if (*nomination == '~' && (home = getenv("HOME"))) {
		strcpy(selection, home);
		strcat(selection, &nomination[1]);
	} else {
		if (strlen(CurrentDir(fnw)) > 1) {
			strcpy(selection, CurrentDir(fnw));
		}
		strcat(selection, "/");
		strcat(selection, nomination);
	}

	len = strlen(selection);
	if (len != 0) {
		newPath = (char *) XtMalloc(len + 2);
		CollapsePath(selection, newPath);
		status = stat(newPath, &fstats);
		if (status != -1 && fstats.st_mode & S_IFDIR) {
			if (access(newPath, R_OK) == 0) {
				if (newPath[strlen(newPath) - 1] != '/') {
					strcat(newPath, "/");
				}
				strcpy(CurrentDir(fnw), newPath);
				ChangeDirectory(fnw, 0);
			} else {
				XBell(XtDisplay(fnw), BellLevel(fnw));
			}
		} else if (status == 0
			   || (status == -1 && errno == ENOENT)) {
			status = access(newPath, R_OK | W_OK);
			r = rindex(newPath, '/');
			XtFree(Nomination(fnw).filenamePart);
			Nomination(fnw).filenamePart = XtNewString(r + 1);
			Nomination(fnw).filenameStatus =
			    (status == 0) ? status : errno;
			*(r + 1) = '\0';
			XtFree(Nomination(fnw).directoryPart);
			status = access(newPath, R_OK);
			if (strcmp(newPath, CurrentDir(fnw)) != 0
			    && status == 0) {
				strcpy(CurrentDir(fnw), newPath);
				ChangeDirectory(fnw, 0);
				Nomination(fnw).directoryPart =
				    XtNewString(CurrentDir(fnw));
			} else {
				Nomination(fnw).directoryPart =
				    XtNewString(newPath);
			}
			Nomination(fnw).directoryStatus =
			    (status == 0) ? status : errno;
			XtCallCallbacks((Widget) fnw, XtNselectCallback,
					(XtPointer) & Nomination(fnw));
		} else {
			XBell(XtDisplay(fnw), BellLevel(fnw));
		}
		XtFree(newPath);
	}
}

static void FillWindow(Widget fnw)
{
	XFontStruct *font;
	Dimension height, internalHeight, rowSpacing;
	int num, newNum, idx;
	struct dirent **namelist;
	extern int alphasort();
	char buf[MAXPATHLEN], *bp;
	String name;
	struct stat fstats;

	num =
	    scandir(CurrentDir(fnw), &namelist, (int (*)()) 0, alphasort);
	if (num <= 0)
		return;
	if (List(fnw)) {
		idx = 0;
		while (List(fnw)[idx])
			XtFree(List(fnw)[idx++]);
		XtFree(List(fnw)[idx]);
		XtFree(List(fnw));
	}
	List(fnw) = (String *) XtMalloc((num + 1) * sizeof(String));

	strcpy(buf, CurrentDir(fnw));
	strcat(buf, "/");
	bp = buf + strlen(buf);
	for (idx = 0, newNum = 0; idx < num; idx++) {
		name = namelist[idx]->d_name;
		strcpy(bp, name);
		(void) stat(buf, &fstats);
		if ((fstats.st_mode & S_IFDIR && ShowDirs(fnw)) ||
		    (match(Pattern(fnw), name) &&
		     (ShowDotFiles(fnw)
		      || (!ShowDotFiles(fnw) && *name != '.')))) {
			List(fnw)[newNum] = XtMalloc(strlen(name) + 2);
			strcpy(List(fnw)[newNum], name);
			if (fstats.st_mode & S_IFDIR)
				strcat(List(fnw)[newNum], "/");
			if (AnnotateMethod(fnw) != NULL) {
				char *ann;
				int j;
				if ((ann =
				     (*AnnotateMethod(fnw)) (CurrentDir
							     (fnw),
							     name)) !=
				    NULL) {
					List(fnw)[newNum] =
					    XtRealloc(List(fnw)[newNum],
						      strlen(List(fnw)
							     [newNum]) +
						      strlen(ann) + 25);
					for (j = strlen(List(fnw)[newNum]);
					     j < 20; j++)
						strcat(List(fnw)[newNum],
						       " ");
					strcat(List(fnw)[newNum], "{");
					strcat(List(fnw)[newNum], ann);
					strcat(List(fnw)[newNum], "}");
					XtFree(ann);
				}
			}
			++newNum;
		}
	}

	for (idx = 0; idx < num; idx++)
		XtFree(namelist[idx]);
	XtFree(namelist);

	List(fnw)[newNum] = NULL;

	XtVaGetValues(Child(fnw, list),
		      XtNfont, &font,
		      XtNinternalHeight, &internalHeight,
		      XtNrowSpacing, &rowSpacing, NULL);

	height = Rows(fnw) * (font->max_bounds.ascent +
			      font->max_bounds.descent + rowSpacing) -
	    rowSpacing + 2 * internalHeight;

	XtVaSetValues(Child(fnw, viewport), XtNheight, height, NULL);

	XawListChange(Child(fnw, list), List(fnw), newNum, -1, True);
}

static void Cancel(Widget w, XEvent * event, String * params,
		   Cardinal * num_params)
{
	CancelCallback(w, NULL, NULL);
}

static void Complete(Widget w, XEvent * event, String * params,
		     Cardinal * num_params)
{
	int idx, l, num, found, foundat;
	char *nomination;
	struct dirent **namelist;
	extern int alphasort();
	FileNominatorWidget fnw = (FileNominatorWidget) XtParent(w);

	XtVaGetValues(Child(fnw, filename), XtNstring, &nomination, NULL);
	num =
	    scandir(CurrentDir(fnw), &namelist, (int (*)()) 0, alphasort);
	l = strlen(nomination);
	found = 0;
	for (idx = 0; idx < num; idx++) {
		if (strncmp(nomination, namelist[idx]->d_name, l) == 0) {
			found++;
			foundat = idx;
		}
	}
	if (found == 1) {
		XtVaSetValues(Child(fnw, filename),
			      XtNstring, namelist[foundat]->d_name, NULL);
		XawTextSetInsertionPoint(Child(fnw, filename),
					 (XawTextPosition)
					 namelist[foundat]->d_name);
	} else {
		XBell(XtDisplay(fnw), BellLevel(fnw));
	}
	for (idx = 0; idx < num; idx++)
		XtFree(namelist[idx]);
	XtFree(namelist);

}

static void DotFiles(Widget w, XEvent * event, String * params,
		     Cardinal * num_params)
{
	Widget fnw = XtParent(w);
	Boolean showDotFiles;

	XtVaGetValues(fnw, XtNshowDotFiles, &showDotFiles, NULL);
	XtVaSetValues(fnw, XtNshowDotFiles, !showDotFiles, NULL);
	XtVaSetValues(Child(fnw, filename), XtNstring, "./", NULL);
	Nominate(Child(fnw, select), NULL, NULL, NULL);
}

static void ReplaceFilename(Widget w, XtPointer client_data,
			    XtPointer call_data)
{
	FileNominatorWidget fnw =
	    (FileNominatorWidget) XtParent(XtParent(w));
	char *p, *q;

	XawListReturnStruct *list = XawListShowCurrent(Child(fnw, list));

	if (AnnotateMethod(fnw) != NULL) {
		q = XtMalloc(strlen(list->string) + 1);
		strcpy(q, list->string);
		if ((p = index(q, ' ')) != NULL)
			*p = 0;
		XtVaSetValues(Child(fnw, filename), XtNstring, q, NULL);
		XtVaSetValues(Child(fnw, filename), XtNstring, q, NULL);
		XawTextSetInsertionPoint(Child(fnw, filename),
					 (XawTextPosition) strlen(q));
		XtFree(q);
	} else {
		XtVaSetValues(Child(fnw, filename), XtNstring,
			      list->string, NULL);
		XtVaSetValues(Child(fnw, filename), XtNstring,
			      list->string, NULL);
		XawTextSetInsertionPoint(Child(fnw, filename),
					 (XawTextPosition) strlen(list->
								  string));
	}
	WatchForChanges(fnw);
}

static void AsciiSourceChanged(Widget w, XtPointer client_data,
			       XtPointer call_data)
{
	FileNominatorWidget fnw = (FileNominatorWidget) client_data;

	DontWatchForChanges(fnw);
	XawListUnhighlight(Child(fnw, list));
}

static void WatchForChanges(Widget fnw)
{
	if (!WatchingChanges(fnw)) {
		XtAddCallback(XawTextGetSource(Child(fnw, filename)),
			      XtNcallback, AsciiSourceChanged,
			      (XtPointer) fnw);
		WatchingChanges(fnw) = True;
	}
}

static void DontWatchForChanges(Widget fnw)
{
	XtRemoveCallback(XawTextGetSource(Child(fnw, filename)),
			 XtNcallback, AsciiSourceChanged, (XtPointer) fnw);

	WatchingChanges(fnw) = False;
}

static void CollapsePath(char *in, char *out)
{
	char *p = in, *q = out, *pend = p + strlen(p);

	while (p < pend) {
		if (*p != '/') {
			*q++ = *p++;
		} else if (p + 1 < pend && *(p + 1) == '/') {
			++p;
		} else if ((p + 2 == pend && *(p + 1) == '.') ||
			   (p + 2 < pend && *(p + 1) == '.'
			    && *(p + 2) == '/')) {
			p += 2;
		} else
		    if ((p + 3 == pend && *(p + 1) == '.'
			 && *(p + 2) == '.') || (p + 3 < pend
						 && *(p + 1) == '.'
						 && *(p + 2) == '.'
						 && *(p + 3) == '/')) {
			while (q > out && *--q != '/');
			p += 3;
		} else {
			*q++ = *p++;
		}
	}
	if (q == out) {
		*q++ = '/';
	}

	while (q > out) {
		if (*--q != '/')
			break;
	}
	*++q = '\0';
}

String FileNominatorGetDirectory(Widget fnw)
{
	if (XtIsSubclass(fnw, fileNominatorWidgetClass)) {
		return CurrentDir(fnw);
	} else {
		return NULL;
	}
}

void FileNominatorSetDirectory(Widget fnw, String dir)
{
	if (!XtIsSubclass(fnw, fileNominatorWidgetClass)) {
		return;
	}

	if (dir) {
		/* Should do more checks */
		strcpy(CurrentDir(fnw), dir);
		if (dir[strlen(dir) - 1] != '/') {
			strcat(CurrentDir(fnw), "/");
		}
	}
	ChangeDirectory(fnw, 0);
}


/*
 * Copyright 1991 The University of Newcastle upon Tyne
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose other than its commercial exploitation
 * is hereby granted without fee, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of The University of Newcastle upon Tyne not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission. The University of
 * Newcastle upon Tyne makes no representations about the suitability of
 * this software for any purpose. It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF NEWCASTLE UPON TYNE DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF
 * NEWCASTLE UPON TYNE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 * 
 * Author:  Jim Wight (j.k.wight@newcastle.ac.uk)
 *          Computing Laboratory, University of Newcastle upon Tyne, UK
 */
