% function [f,m,p] = xdview_getcal(filename)
%
% use xdview to read filename and get earcal data

function [freqs,mags,phases] = xdview_getcal(filename)

[s,w] = unix(['xdview -params ' filename]);
if(strcmp(w,''))
  filename = cat(2,filename,'.gz');
  [s,w] = unix(['xdview -params ' filename]);
end

pos = findstr(w,'cal.mono');
side = sscanf(w(pos(1)+9:pos(1)+9),'%s');

[s,w] = unix(['xdview -mag -text ' filename]);

[data, nlines] = read_text_data(w);

if strcmp(side,'B')
	freqs = data(1:nlines/2, 1);
	mags(:,1) = data(1:nlines/2, 2);
	mags(:,2) = data(nlines/2 + 1:nlines, 2);
else
	freqs = data(:,1);
	if strcmp(side,'L')
		mags(:,1)=data(:,2);
		mags(:,2)=zeros(size(data(:,2)));
	else
		mags(:,1)=zeros(size(data(:,2)));
		mags(:,2)=data(:,2);
	end
end

[s,w] = unix(['xdview -phase -text ' filename]);

[data, nlines] = read_text_data(w);

if strcmp(side,'B')
	phases(:,1) = data(1:nlines/2, 2);
	phases(:,2) = data(nlines/2 + 1:nlines, 2);
else
	if strcmp(side,'L')
		phases(:,1)=data(:,2);
		phases(:,2)=zeros(size(data(:,2)));
	else
		phases(:,1)=zeros(size(data(:,2)));
		phases(:,2)=data(:,2);
	end
end
		
% ------------------------------------------------------------
function [data, nlines] = read_text_data(w)

pos = findstr(w,'RASTERDATA');
j=18;

while ~isspace(w(pos(1)+j))
	j = j+1;
end
nlines = sscanf(w(pos(1)+18:pos(1)+j),'%f');

while isspace(w(pos(1)+j)) 
	j = j+1; 
end

data = sscanf(w(pos(1)+j:pos(2)-6),'%f');
data = reshape(data,length(data)/nlines,nlines);
data = data';
