function [BOB, EOB, SOB]=spk_burst(InTrain, StartT, StopT)
% This program finds burst parameters for a given trial.
% The function CALL_SPKBURST calls this program in a trial-by-trial
% manner. The returned values are arrayed trial-by-trial by CALL_BURST.
% NOTE: Calls POISSCDF function in the STATISTICS toolbox
% Function:
%       SPK_BURST
% Example:
%      [BOB, EOB, SOB]=spk_burst(InTrain, StartT, StopT)
%  	See comments in CALL_SPKBURST
% Author:
% 	chenchal.subraveti@vanderbilt.edu
% Problems:
% 	Copy error message(s) and email to chenchal.subraveti@vanderbilt.edu
% Based on burst.c 
%	For Details see: Hanes, Thompson & Schall (1995) Exp. Brain Res. (103), 85-96
%						  Thompson, Hanes, Bichot & Schall (1996) J. Neurophys (76), 4040-4055

%******************User Parameters************************
MaxXT=50;%Max Xtra Time
MaxXS=10;%Max Xtra Spikes
MinSPInBurst=0;%Minimum spkes in a Burst
Anchor=10;%Anchor Time
Signif=0.05;% SIGNIFICANCE level
UserSI=-log(Signif);
%%%%%%%%%%%DO NOT MODIFY BELOW THIS LINE%%%%%%%%%%%%%%%%
MinSPinBurst=MinSPInBurst-2;
Tol=1e-300;
%****************Spike Train Properties*****************
if(size(InTrain,1))>1
   InTrain=InTrain';
end
SPT=InTrain(find(InTrain > 0 & InTrain < Inf))';
StopT=max(0,StopT);%traps NaN
StartT=max(0,StartT);%traps NaN
if(~StopT),StopT=max(SPT);,end
if(~StartT),StartT=min(SPT);,end
minT=min(StartT,StopT);
maxT=max(StartT,StopT);
StartT=minT;StopT=maxT;
Duration=StopT-StartT;
%Average Spike Rate MU
if(~isempty(SPT))
   %Calculate Average spike rate between start and stop time
   MU=(length(find(SPT>= StartT & SPT <= StopT)))/(Duration);
   %if there are no spikes in the selected interval
   %find MU for the entire trial
   if (MU==0)
      MU=(length(SPT)-1)/(max(SPT)-min(SPT));
   end
   %if there are no spikes in the spike train or 
   %n spikes in train is less than 4
   if(MU==0 | length(SPT)<=4)
      BOB=[];
      EOB=[];
      SOB=[];
      return
   end
else
   BOB=[];
   EOB=[];
   SOB=[];
   return
end
MaxSpikes=length(SPT);
ISI=diff(SPT);%Inter Spike Intervals
%################Parameter Initializations##############
%******Flags, Counters, Indices and Rel. OPs************
ISBURST=0;
BNo=1;CurrBNo=0;%Burst No for indexing
MinBOB=5000;%Dummy
MaxEOB=0;%Dummy
OldBOB=0;OldEOB=0;
PrevBOB=0;PrevEOB=0;
CurrBOB=0;CurrEOB=0;
CurrEOB_XS=0;CurrXS=0;CurrXT=0;%Vars for Extra Time
MaxSI=0;
%*******************Iteration vars**********************
Iterate=1;IC=1;%Iteration Counter
FromI=0;ToI=0; %Current portion of Spike Train
FspAB=1;%First spike After Burst
Temp=0;Done=0;
%******************Output Arguments*********************
BOB=[];EOB=[];SOB=[];%MUST be set to EMPTY
%########################################################
while(FspAB <= MaxSpikes-1 | ~Done)
   Iterate=1;
   while(Iterate)
      %***************FIND EOB****************************
      if (IC==1)
         FromI=FspAB;
      else
         FromI=CurrBOB;
      end
      cISI=cumsum(ISI(FromI:length(ISI)))+Anchor;
      %Prob=(poisscdf([1:length(cISI)]', cISI.*MU))+Tol;
      Prob=poisscdf([1:length(cISI)]', cISI.*MU);
      Prob=(1-Prob);
      SI=-log(Tol+Prob);
      %find index that maximizes SI
      Temp=(find(diff(SI)<0));
      if (length(Temp)>1)
         CurrEOB=Temp(min(find(Temp >1)));
         if(CurrEOB==1 & IC==1)
            FspAB=Temp(min(find(diff(Temp) >=MinSPInBurst)))+1;
            if (isempty(FspAB) | FspAB>=MaxSpikes-MinSPInBurst)
               Done=1;
               ISBURST=0;
               Iterate=0;
            end
            break %Break out of Iteration
         end
         CurrEOB_XS=0;Curr_XT=0;
         %check for extra spikes and extra time
         %Find index to next MaxSI
         CurrEOB_XS=min(find(SI > SI(CurrEOB)));
         if(~isempty(CurrEOB_XS))
            CurrXS=CurrEOB_XS-CurrEOB-1;
            CurrXT=SPT(CurrEOB_XS)-SPT(CurrEOB);
            if(CurrXS <= MaxXS & CurrXT <= MaxXT)
               CurrEOB=CurrEOB_XS;
               CurrEOB_XS=0;
            end
         end
      elseif (length(Temp)==1 & ~isempty(Temp))
         CurrEOB=Temp;
      elseif(isempty(Temp))
         %Index to the max 
         CurrEOB=length(SI);
      else
      end
      CurrEOB=CurrEOB+FromI;
      %***************FIND BOB****************************
      ToI=FspAB;
      BSPT=SPT(CurrEOB:-1:ToI);
      cISI=cumsum(abs(diff(BSPT)))+Anchor;
      Prob=poisscdf([1:length(cISI)]',cISI.*MU);
      Prob=(1-Prob);
      SI=-log(Tol+Prob);
      Temp=max(find(SI==max(SI)));
      %What if Temp = [];??
      if (isempty(Temp))
         disp('ERROR finding BOB ==> Temp is EMPTY')
         [Temp]
      end
      CurrBOB=find(SPT==BSPT(Temp+1));
      %if diff between CurrEOB and recently found BOB is < criteria
      if (CurrEOB-CurrBOB) <= MinSPInBurst
         ISBURST=0;
         Iterate=0;
         FspAB=CurrEOB+1;
         FromI=FspAB;
         break;%Break out of Iteration loop
      end
      %Check for convergence among 3 values for each
      if(OldBOB==CurrBOB & OldEOB==CurrEOB )
         %Converged
         %disp(['Burst Number ',num2str(BNo),' Converged in ',num2str(IC),' iterations'])
         %disp(['BOB Index ',num2str(CurrBOB),' EOB Index 'num2str(CurrEOB)])
         Iterate=0;
         ISBURST=1;
         break
      else
         IC=IC+1;
         PrevBOB=OldBOB;
         PrevEOB=OldEOB;
         OldBOB=CurrBOB;
         OldEOB=CurrEOB;
      end
      %find max and min
      CurrBNo=max(CurrBNo,BNo);
      if(CurrBNo)
         MaxEOB=max(CurrEOB,MaxEOB);
         MinBOB=min(CurrBOB,MinBOB);
      end
      if(IC==10)
         MaxEOB=CurrEOB;MinBOB=CurrBOB;
      elseif(IC>20)
         CurrEOB=MaxEOB;CurrBOB=MinBOB;
         Iterate=0;
         ISBURST=1;
      else
      end
      %disp(['End of Iteration cycle : ',num2str(IC-1)])
   end%while(Iterate) 
   if(ISBURST)
      %CHECK CRITERIA
      MaxSI=-log(Tol+(1-(poisscdf(CurrEOB-CurrBOB,(SPT(CurrEOB)-SPT(CurrBOB))*MU))));
      if(CurrEOB-CurrBOB >= MinSPInBurst & MaxSI>UserSI)
         BOB(BNo)=SPT(CurrBOB);
         EOB(BNo)=SPT(CurrEOB);
         SOB(BNo)=MaxSI;
         BNo=BNo+1;
      end
      FspAB=CurrEOB+1;
      CurrBOB=FspAB;
      IC=1;
   else
      IC=1;
   end
   %Check limits
   if(FspAB >= MaxSpikes-2)
      Done=1;
      Iterate=0;
      break
   end
end%while(FspAB <= MaxSpikes-1)
%****************************DISPLAY***********************************
clf
colors_='rbm';
colors_=repmat(colors_,1,ceil(length(EOB)/length(colors_)));
%It takes less time to put '+' than draw line/ticks
%h=plot(SPT,1,'k+');
set(line([SPT SPT],[0.95 1.05]),'color',[0 0 0],'linewidth',0.1);
hold on
minX=StartT-50;
axis([minX max(SPT)+100 0 2])
set(findobj('type','axes'),'color',[1 1 1],'ytick',[],'box','on')
for EB=1:length(EOB)
   %   plot(SPT(BOB(EB):EOB(EB)),1.1,strcat(colors_(EB),'+'));
   plot((BOB(EB):EOB(EB)),1.1,strcat(colors_(EB),'-'));
end
disp('done1')
%This part depends on the user...
% MIN INTER BURST INTERVAL
%InterBDiff=SPT(BOB(2:length(BOB)))-SPT(EOB(1:length(EOB)-1));


