function data=readwave(file)
% USAGE: DATA = READWAVE('FILENAME');
%
%   Load analog waveforms from the xdowl analog data file FILENAME.
%   Waveforms are returned in DATA; if there were N waveforms, each M
%		samples long, with L channels, then DATA is M by N by L.  DATA(:,1) 
%   is the first waveform, and WAVE(:,N) is the last.
%
%   You must UNCOMPRESS the analog datafile before using this function.
%   If it has ".Z" at the end of the filename, it is compressed.
%   Outside of matlab, run
%
%	uncompress <datafile>
%
%   and then use READWAVE in matlab to read the resulting file.

% The header struct is:
%
%  int        magic
%  int        fc
%  int        nsamps
%  int        nchans
%  char[100]  comment
%  int        bits
%  char[20]   program
%  char[20]   arch
%  int        tomv
%  int        tomv_div
%  int        offset
%  int        offset_div
%  char[336]  padding

%  it's 512 bytes long, and is described in xdphys/src/waveio.h
%  xdphys is probably compiled to align structs along 4 byte boundries,
%  so types with size < 4 get converted to 4 bytes in the header.

%----------------------
% Set some variables
%----------------------
%trace_num = 1;

fid=fopen(file, 'r', 'b');
if fid == (-1),
	error(['Unable to open file ', file]);
end;

[magic,count] = fread(fid,1,'int');

disp(sprintf('Loading analog waveforms from %s ...', file));

fc = fread(fid,1,'int');
nsamps = fread(fid,1,'int');
nchans = fread(fid,1,'int');
com = fread(fid,100,'char');
pad = fread(fid,44,'char');
to_mv = fread(fid,1,'int');
to_mv_div = fread(fid,1,'int');
offset = fread(fid,1,'int');
offset_div = fread(fid,1,'int');
pad = fread(fid,336,'char')';

x=fread(fid,nsamps*nchans,'short');
if ((to_mv_div ~= 0) & (offset_div ~= 0)),
	data = reshape(x *(to_mv/to_mv_div) + (offset/offset_div), nchans, nsamps);
else
	data = reshape(x, nchans, nsamps);
end
data = data';
