% function plotana(d,n,adfc,pre,post,maxn)
%
% d is output of readana; n is output of fdread
% adfc is the sampling rate
% pre and post specify how many milliseconds to display
% plots only maxn spikes

function plotana(d,n,adfc,pre,post,maxn)

% first, undo crazy format

k=0;
for i = 1:length(d)
  for j = 1:length(d(i).rasternums)
    k=k+1;
    dd(k).trace = d(i).traces(:,j);
    dd(k).rasternum = d(i).rasternums(j);
  end
end

pre = pre*1e-3*adfc;
post = post*1e-3*adfc;

clf reset
hold on
k=0;
thresh=1e6;
for i = 1:length(dd)
  n.rasters(:,1)==dd(i).rasternum;
  ts = n.rasters(ans,2);
  ts = ts*1e-7*adfc;
  for j = 1:length(ts)
    k=k+1;
    from = max([1 round(ts(j)-pre)]);
    to = min([length(dd(i).trace) round(ts(j)+post)]);
    x1 = -pre + (from-round(ts(j)-pre));
    x2 = post - (to-round(ts(j)+post));
    plot([x1:x2]/adfc*1e3,dd(i).trace(from:to));
    thresh = min([thresh dd(i).trace(round(ts(j)+1))]);
  end
  if(k==maxn)
    break;
  end
end

plot([-pre post]/adfc*1e3,[thresh thresh],'r');
