function result=peakfreq(filename, start_ms, end_ms, fc)

%function result=peakfreq('filename', start_ms, end_ms, fc(kHz),cuales)
%plots the median within start_ms and end_ms. peakfreq returns a matrix of
%median resting membrane potential and median membrane potential within start_ms
%and end_ms
%
% cuales, por ejemplo:  [1:4], [1 3:5], [1 2 3 4]


clf;
StartRow = start_ms*fc;
EndRow = end_ms*fc;
RestingStart = 1;
RestingEnd = 100*fc;

%mean for each trace avoiding spikes:
data = readana(filename);

for i = 1:length(data),
	traces= data(i).traces;
	stim = traces(StartRow:EndRow,:)/10;
	rest = traces(RestingStart:RestingEnd,:)/10;
	peak(i)=find_peak(stim,fc);
	rest_peak(i)=find_peak(rest,fc);
	depints(i)=data(i).depint;
end

plot(depints,peak,depints,rest_peak,'--');


%===================================================
function peak=find_peak(traces, fc)
% return freqency of greatest power

fc_half=(fc*1000)/2;
trace_mean=mean(traces');
trace_fft=abs(fft(trace_mean));
halfway=round(length(trace_fft)/2);
lowstop=round((3000*halfway)/(fc_half));
trace_fft(1:lowstop)=0;
[peak_mag,peak_index]=max(trace_fft(lowstop:halfway));
peak_index=peak_index+lowstop;
peak=(peak_index/halfway)*fc_half
%freqs=[1:halfway]*(1/halfway)*fc_half;
%plot(freqs,trace_fft(1:halfway),freqs(peak_index),peak_mag,'ro');
%pause;
