#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <mex.h>
#include <nr.h>

/*----------------------------------------------------------------------- */
/*----------------------------------------------------------------------- */

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
	int n,i;
	double *x,*y,*sig_x,*sig_y;
	float *f_x,*f_y,*f_sig_x,*f_sig_y;
	float a,b,siga,sigb,chi2,q;
	double *a_out,*b_out,*siga_out,*sigb_out,*chi2_out,*q_out;

	if (nrhs != 4)
		mexErrMsgTxt("usage: [a,b,sig_a,sig_b,chi2,q] = fitexy(x,y,sigx,sigy);\n");
	if ((nlhs < 2) || (nlhs > 6))
		mexErrMsgTxt("usage: [a,b,sig_a,sig_b,chi2,q] = fitexy(x,y,sigx,sigy);\n");

	n=mxGetN(prhs[0]);
	if (mxGetN(prhs[1]) != n)
		mexErrMsgTxt("x and y must be the same length!\n");
	if (mxGetN(prhs[2]) != n)
		mexErrMsgTxt("sig_x must be the same length as x!\n");
	if (mxGetN(prhs[3]) != n)
		mexErrMsgTxt("sig_y must be the same length as y!\n");

	x = mxGetPr(prhs[0]);
	y = mxGetPr(prhs[1]);
	sig_x = mxGetPr(prhs[2]);
	sig_y = mxGetPr(prhs[3]);

	mxAssert(((f_x = (float *) mxCalloc(n+1, sizeof(float))) != NULL), 
		"mxCalloc returns NULL!");
	mxAssert(((f_y = (float *) mxCalloc(n+1, sizeof(float))) != NULL), 
		"mxCalloc returns NULL!");
	mxAssert(((f_sig_x = (float *) mxCalloc(n+1, sizeof(float))) != NULL), 
		"mxCalloc returns NULL!");
	mxAssert(((f_sig_y = (float *) mxCalloc(n+1, sizeof(float))) != NULL), 
		"mxCalloc returns NULL!");

	for (i=1; i<(n+1); i++) {
		f_x[i] = (float) x[i-1];
		f_y[i] = (float) y[i-1];
		f_sig_x[i] = (float) sig_x[i-1];
		f_sig_y[i] = (float) sig_y[i-1];
	}

	/* fitexy() is a Numerical Recipies 2nd Ed. function */
	fitexy(f_x,f_y,n,f_sig_x,f_sig_y,&a,&b,&siga,&sigb,&chi2,&q);

	mxFree(f_sig_y);
	mxFree(f_sig_x);
	mxFree(f_y);
	mxFree(f_x);

	/* a */
	plhs[0]=mxCreateDoubleMatrix(1,1,mxREAL);
	a_out=mxGetPr(plhs[0]);
	*a_out=(double) a;

	/* b */
	plhs[1]=mxCreateDoubleMatrix(1,1,mxREAL);
	b_out=mxGetPr(plhs[1]);
	*b_out=(double) b;

	if (nlhs > 2) {
		/* siga */
		plhs[2]=mxCreateDoubleMatrix(1,1,mxREAL);
		siga_out=mxGetPr(plhs[2]);
		*siga_out=(double) siga;

		/* sigb */
		plhs[3]=mxCreateDoubleMatrix(1,1,mxREAL);
		sigb_out=mxGetPr(plhs[3]);
		*sigb_out=(double) sigb;
	}

	if (nlhs > 4) {
		/* chi2 */
		plhs[4]=mxCreateDoubleMatrix(1,1,mxREAL);
		chi2_out=mxGetPr(plhs[4]);
		*chi2_out=(double) chi2;
	}

	if (nlhs == 6) {
		/* q */
		plhs[5]=mxCreateDoubleMatrix(1,1,mxREAL);
		q_out=mxGetPr(plhs[5]);
		*q_out=(double) q;
	}


}
