%define Version 2.7.3
%define Release 1

Summary		: xdphys aids in dichotic auditory neurophysiology, with TDT support
Name		: xdphys-tdt
Version		: %{Version}
Release		: %{Release}
Group		: Applications/Scientific

Copyright	: GPL
Packager	: cmalek@etho.caltech.edu (Chris Malek)

BuildRoot	: /tmp/tdt-driver-%{Version}

Source: ftp.etho.caltech.edu:/pub/xdphys/xdphys-%{Version}.tar.gz
requires: iserver-tdt >= 1.2.10, synth >= 1.0.18, jgraph >= 8.3, sanal >= 1.1, ss >= 1.1.9, epslayout >= 1.1

%description
The xdphys package is a set of programs for performing dichotic auditory 
neurophysiological experiments.  Uses TDT aware version of the iserver
package to do DAQ with TDT equipment

%prep
%setup -n xdphys

%build
make 

%install
DESTDIR=$RPM_BUILD_ROOT; export DESTDIR
[ -n "`echo $DESTDIR | sed -n 's:^/tmp/[^.].*$:OK:p'`" ] && rm -rf $DESTDIR ||
(echo "Invalid BuildRoot: '$DESTDIR'! Check this .spec ..."; exit 1) || exit 1

for dir in usr/local/lib usr/local/include usr/lib/X11/app-defaults usr/local/local-matlab; do
	install -m 755 -d $DESTDIR/$dir
done

INSTALL_ROOT=$DESTDIR/usr; export INSTALL_ROOT
make -e install
(cd calib; make -e install)

%files 
%defattr(-,root,root)
/usr/local/bin/xdphys/xdphys
/usr/local/bin/xdphys/xcalibur
/usr/local/bin/xdphys/xdview
/usr/local/bin/xdphys/xclockbar
/usr/local/bin/xdphys/m2a
/usr/local/bin/xdphys/fix3and5
/usr/local/bin/xdphys/xdprint
/usr/local/bin/xdphys/xdprint_all
/usr/local/bin/xdphys/xdp_waitforlp
/usr/local/bin/xdphys/mod_gen.gawk
/usr/local/bin/xdphys/depselect
/usr/local/bin/xdphys/repselect
/usr/local/bin/xdphys/xdsetup
/usr/local/lib/xdphys/xdphysrc.tar.gz
/usr/local/lib/xdphys/doc/xcalibur.fr.doc
/usr/local/lib/xdphys/doc/xcalibur.cal.doc
/usr/local/lib/xdphys/doc/xcalibur.int.doc
/usr/local/lib/xdphys/doc/xcalibur.bw.doc
/usr/local/lib/xdphys/doc/xcalibur.config.doc
/usr/local/lib/xdphys/doc/xcalibur.doc
/usr/local/lib/xdphys/doc/xdphys.bam.doc
/usr/local/lib/xdphys/doc/xdphys.beats.doc
/usr/local/lib/xdphys/doc/xdphys.doc
/usr/local/lib/xdphys/doc/xdphys.bf.doc
/usr/local/lib/xdphys/doc/xdphys.cf.doc
/usr/local/lib/xdphys/doc/xdphys.fiid.doc
/usr/local/lib/xdphys/doc/xdphys.iid.doc
/usr/local/lib/xdphys/doc/xdphys.itd.doc
/usr/local/lib/xdphys/doc/xdphys.click.doc
/usr/local/lib/xdphys/doc/xdphys.prefs.doc
/usr/local/lib/xdphys/doc/xdphys.rig.doc
/usr/local/lib/xdphys/doc/xdphys.twosound.doc
/usr/local/lib/xdphys/doc/xdview.doc
/usr/local/lib/xdphys/doc/xdview.parms.doc      
/usr/local/local-matlab/showtraces.m
/usr/local/local-matlab/readwave.m
/usr/local/local-matlab/nspikes.m
/usr/local/local-matlab/xdview_curve.m
/usr/local/local-matlab/xdview_getcal.m
/usr/local/local-matlab/xdview_isih.m
/usr/local/local-matlab/xdview_psth.m
/usr/local/local-matlab/stimpower.m
/usr/local/local-matlab/fdread.m
/usr/local/local-matlab/getvar.m
%config /usr/lib/X11/app-defaults/XDphys
%config /usr/local/lib/xdphys/calib/tdt.addacal.data
%config /usr/local/lib/xdphys/calib/tdt-knowles.kleft.fr
%config /usr/local/lib/xdphys/calib/tdt-knowles.kright.fr
%config /usr/local/lib/xdphys/calib/blank.fr
