/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: xstuff.h,v 2.45 1997/09/05 00:08:04 cmalek Exp $
** Program: dowl
**  Module: xstuff.h
**  Author: mazer
** Descrip: interface for xstuff.c
**
** Revision History (most recent last)
**
*******************************************************************/

extern Widget	top_new(Widget, char*);
extern Widget	pop_new(Widget, char*);

extern Widget	form_new(Widget, char*, int);
extern Widget	box_new(Widget, char*, int);
extern Pixmap 	makePixmap(char*, unsigned int, unsigned int);

extern void 	popup_at(Widget, Position, Position);
extern void 	popup_pointer(Widget);
extern void 	popup(Widget);
extern void 	xpopup(Widget);
extern void 	popdown(Widget);
extern void 	popkill(Widget);

extern void 	HidePShellCB(Widget, XtPointer, XtPointer);		/* callback for "Hide" buttons */
extern void 	ClosePShellCB(Widget, XtPointer, XtPointer);	/* callback for "Close" buttons */
extern void 	ExposePShellCB(Widget, XtPointer, XtPointer);	/* callback for ptool-like buttons */
extern void	PShellDestroyedCB(Widget, XtPointer, XtPointer); 	/* callback to cleanup before close */

extern void	beep(int);
extern int	ConvertColor(Widget, char*);
extern void	ReverseColors(Widget);

extern int	char_size(Widget, int*, int*);
extern void	set_led(int, int);

extern int	PercentDisplayWidth(int, int);
extern int	PercentDisplayHeight(int, int);
