/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: xdphys_mods.c,v 1.9 2000/11/27 07:04:15 cmalek Exp $
** Program: dowl
**  Module: xdowl_mods.c
**  Author: mazer
** Descrip: place to install new applications/modules
**
** Revision History (most recent last)
**
** Sat Feb 15 19:22:17 1992 mazer
**  updated to use an application dock
**
** Mon Nov 22 23:29:13 1993 mazer
**  changed install_apps() to install_modules()
**  changed filename from xdowlapps.c to xdowl_mods.c
**
*******************************************************************/

#include "xdphyslib.h"
#include "xdphys.h"

#ifndef MOD_MENU
#define D_ADD(dk,suf,fn) { extern Widget (fn)(DockSlot*); \
      dock_add_delayed((dk), (suf), (fn)); }

void install_modules(Dock *dock)
{
  /*
   * Here's the place to register data collection methods/worksheets:
   */

  D_ADD(dock, "rig",	 setupRig);
  D_ADD(dock, "gen", 	 setupGen);
#ifndef __linux__
  D_ADD(dock, "bja", 	 setupBja);
#endif /* __linux__ */
  D_ADD(dock, "cf",	   setupCf);
  D_ADD(dock, "fiid",  setupFiid);
  D_ADD(dock, "beats", setupBeats);
  D_ADD(dock, "click", setupClick);
#if(0)
  D_ADD(dock, "bc", 	 setupBc);
  D_ADD(dock, "nop", 	 setupNop);
  D_ADD(dock, "abi", 	 setupAbi);
  D_ADD(dock, "itd", 	 setupItd);
  D_ADD(dock, "iid",	 setupIid);
  D_ADD(dock, "bf",	   setupBf);
  D_ADD(dock, "ot1",	 setupOt1);
  D_ADD(dock, "rover", setupRover);
  D_ADD(dock, "mono",  setupMono);
  D_ADD(dock, "bam",	 setupBam);
  D_ADD(dock, "sps", 	 setupSps);
  D_ADD(dock, "itd2", 	 setupItd);
  D_ADD(dock, "freq2",	 setupFreq2);
  D_ADD(dock, "period",  setupPeriod);
  D_ADD(dock, "rover2",  setupRover);
#endif
}
#else /* MOD_MENU */

static void M_ADD(MENU_ENTRY **, int, char *, void (*fn)());

void module_menu(MENU_ENTRY **menu)
{
    int i = 0;

    M_ADD(menu, i, "rig", setupRig); i++;
    M_ADD(menu, i, "abi", setupAbi); i++;
    M_ADD(menu, i, "bf", setupBf); i++;
    M_ADD(menu, i, "cf", setupCf); i++;
    M_ADD(menu, i, "itd", setupItd); i++;
    M_ADD(menu, i, "iid", setupIid); i++;
    M_ADD(menu, i, "rover", setupRover); i++;
    M_ADD(menu, i, "mono", setupMono); i++;
    M_ADD(menu, i, "fiid", setupFiid); i++;
    M_ADD(menu, i, "bc", setupBc); i++;

    /* This line MUST be here, and must be last */
    M_ADD(menu, i, NULL, NULL); 

}

static void M_ADD(
    MENU_ENTRY **menu, 
    int entry_num, 
    char *label, 
    void (*callback_fn)())
{
    if (*menu == NULL) {
	*menu = (MENU_ENTRY *) calloc(entry_num+1, sizeof(MENU_ENTRY));
	assert(*menu != NULL);
    } else {
	*menu = (MENU_ENTRY *) realloc((void *) *menu, 
	    (entry_num+1)*sizeof(MENU_ENTRY));
	assert(*menu != NULL);
    }

    (*menu)[entry_num].label_str = label;
    (*menu)[entry_num].callback_fn = callback_fn;
    (*menu)[entry_num].callback_data = NULL;
    (*menu)[entry_num].svar_name = NULL;

}

}
#endif /* MOD_MENU */

/* the mods suffixed in 2 are two-tone/masking modules.  with the new
   calibration modifications, the way these routines synthesize stimuli
   needs to be completely rethought/reprogrammed, and I don't have time
   now.  No one in the lab seems to be using them currently, so I'll
   think about it later.  bjarthur, aug 96 */
