/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: xclockbar.c,v 1.5 1998/07/22 18:15:59 bjarthur Exp $
** Program: dowl
**  Module: clockbar.c
**  Author: mazer
**  Decrip: embedded or standalone clockbar
**
** Revision History (most recent last)
**
** Sun Nov 22 13:12:03 1992 mazer
**  creation date :: derived from xdowl.c and xanalysis.c
**
** Wed Nov 25 23:03:36 1992 mazer
**  can now be compiled as is for a clockbar_build function
**  or with -DSTANDALONE to make a standalone tool
**
** Tue Mar  8 00:22:06 1994 mazer
**  now it's a stand alone program..
**
*******************************************************************/

#include "xdphyslib.h"

char *statefile = NULL;

static void QuitCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data;
     caddr_t call_data;
{
  clockbar_save();
  exit(0);
}

static void install_actions()
{
  static XtActionsRec actionTable[] = {
    { "quit",		QuitCB		},
  };

  XtAppAddActions(XtWidgetToApplicationContext(TopLevel),
		  actionTable, XtNumber(actionTable));
}

static void usage(pname, badarg)
     char *pname;
     char *badarg;
{
  fprintf(stderr, "xclockbar -- Version %s -- JM\n\
usage: %s [-ov][-alarm mins][-interval secs]\n\
  -ov       = override lock\n\
  -alarm    = set drug-alarm time in mins (def=60min)\n\
  -interval = update interval (5secs)\n",
	  XDPHYS_VERSION, pname);

  if (badarg)
    fprintf(stderr, "\n%s: unknown argument \"%s\"\n\n", pname, badarg);

  if (badarg)
    exit(1);
}

int main(ac, av)
     int ac;
     char **av;
{
  int arg;
  int drug_alarm = 0;
  int update_interval = 0;
  Widget form;

  progname = av[0];
  makeXDphysrc();
  initsvars();

#define isarg(pat) (strncmp(av[arg], pat, strlen(av[arg])) == 0)
  for (arg = 1; arg < ac; arg++) {
    if (isarg("-alarm")) {
      drug_alarm = atoi(av[++arg]);
    } else if (isarg("-interval")) {
      update_interval = atoi(av[++arg]);
    } else if (isarg("-ov")) {
      unlockApp();		/* blow away the lock, if any */
    } else if (isarg("-debug")) {
      debugflag = 1;
    } else if (isarg("-help") || isarg("-usage")) {
      usage(progname, NULL);
      exit(0);
    } else if (*av[arg]) {
      usage(progname, av[arg]);
    }
  }
#undef isarg
  
  startx(&ac, av, "xclockbar", "XDphys");
  install_actions();

  lockApp();

  form = clockbar_build(TopLevel, drug_alarm, update_interval, QuitCB);

  XtRealizeWidget(TopLevel);

  dloop();			/* bye bye.. */
  exit(0);
}
