/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: xcalibur_mods.c,v 1.4 1998/07/22 18:15:59 bjarthur Exp $
** Program: dowl
**  Module: calib_mods.c
**  Author: mazer
** Descrip: place to install new applications/modules
**
** Revision History (most recent last)
**
** 05 NOV 96 bjarthur
**  copied from xdowl_mods.c
**
*******************************************************************/

#include "xdphyslib.h"
#include "xcalibur.h"

#define D_ADD(dk,suf,fn) { extern Widget (fn)(DockSlot*); \
      dock_add_delayed((dk), (suf), (fn)); }

void install_modules(Dock *dock)
{
  D_ADD(dock, "fr", 	setupFr);
  D_ADD(dock, "cal", 	setupCal);
  D_ADD(dock, "int", 	setupInt);
  D_ADD(dock, "bw", 	setupBw);
}
