/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: waveio.h,v 2.47 2001/03/27 06:59:28 cmalek Exp $
** Program: dowl
**  Module: waveio.h
**  Author: mazer
** Descrip: interface file for waveio.c
**
** Revision History (most recent last)
**
** Fri Nov 18 12:08:59 1994 mazer
**  added calibration fields for WAVEINFO structure..
**
** 98.02 bjarthur
**  added xdphys_filename and rasternum to struct waveinfo to facilitate
**  analysis of neural analog data, particularly extracellular data.
** 
*******************************************************************/

/*
** NOTE: that waveio routines are expected to pad this structure
** out to HEADER_SIZE bytes by writing HEADER_PAD bytes after
**  the structure itself.
*/

#define WAVEINFO struct waveinfo

struct waveinfo {
  short	majik;			/* majik number */
  int	fc;			/* sampling frequency in Hz */
  int	nsamps;			/* number of samples */
  int	nchans;			/* number of channels */
  char	comment[100];		/* application usable comment field */
  char	bits;			/* bits per sample */
  char	program[20];		/* program that made file*/
  char	arch[20];		/* architecture that made file */

  /* added Nov 18, 1994 */
  int	tomv, tomv_div;		/* mult by (tomv/tomv_div) to convert to mv */
  int	offset, offset_div;	/* add (off/off_div) to adjust for offset */

	char xdphys_filename[32];
	int xdphys_rasternum;
};

#define HEADER_SIZE 	512
#define HEADER_PAD	(HEADER_SIZE - sizeof(WAVEINFO))

#define WAVE_MAJIK_0	0x5730	/* "W0" */
#define WAVE_MAJIK	0x5731	/* "W1" */
/* #define ANA_MAJIK	0x5732       used by xdview.c:ana(), 
 * 									in file.version == 1  files  */
#define ANA_MAJIK	0x5733	/* used by xdview.c:ana() */


extern int writewave(FILE*, xword*, int, int, int, char*, char*, float, float,
			char*,int);
extern int savewave(char*, xword*, int, int, int, char*, char*, float, float,
			char*,int);
extern int appendwave(char*, xword*, int, int, int, char*, char*, float, float,
			char*,int);

extern xword   *readwave(FILE*, WAVEINFO**);
extern int			wave_getcalib(WAVEINFO*, float*, float*);
extern xword   *loadwave(char*, WAVEINFO**);
extern xword   *nthwave(char*, WAVEINFO**, int, int*);
extern int			iswavefile(char*);	/* returns number of waves inside.. */
extern xword   *loadsongedfile(char*, WAVEINFO**);
