/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: unittrace.h,v 2.47 1999/02/14 05:05:12 bjarthur Exp $
** Program: dowl
**  Module: unittrace.h
**  Author: mazer
** Descrip: interface for unittrace.c
**
** Revision History (most recent last)
**
*******************************************************************/

typedef struct tracer_data {

  /* public members */
  Widget form;			/* form containing EVERYTHING */
  Widget paned;			/* panel display for traces */
  ATH *psth;			/* peri-stim-time histogram */
  ATH *isih;			/* inter-spike-interval histogram */
  DRASTER *raster;		/* raster display */
  Widget scope;			/* peri-event digital scope */
  Widget wave;			/* optional analog trace */
  Widget mask_button;		/* show/set currently viewed model/channel */
  Widget ssbutts[7];		/* ss butts to turn off when not ss'ing*/
  Widget autoscale;		/* autoscale mode for scope widget */
  Widget active;		/* update display? */
#if(0)
  Widget scopeform;		/* form to hold dscope & buttons */
  Widget discrim;		/* display discrim box? */
  Widget ac_coup;		/* AC couple the trace output? */
  int ms_pre, ms_post;		/* time window around events for scope dpy */
#endif
  int mask;			/* current mode/channel value*/

  /* private members */
  struct tracer_data *prev;	/* linked list for auto-updates */
  struct tracer_data *next; 
  int rnum;			/* current raster number <- no longer used */
  int killme;			/* destroy me next time it's safe.. */
  int wd, ht;			/* height and width for cloning.. */
} TRACER;

extern void tracer_add_discrim(TRACER*);
extern TRACER 	*tracer_new(Widget, int, int, int, TRACER*);
extern void	 tracer_update(TRACER*, spike_t *, xword*, int, int, int, int);
extern void	 tracer_clear(TRACER*);
extern void	 tracer_add_discrim(TRACER*);
extern void  ClearTracerAction(Widget, XEvent*, String*, Cardinal*);
