/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: systems.c,v 2.53 2000/11/10 22:37:46 cmalek Exp $
** Program: xdphys
**  Module: systems.c
**  Author: mazer
** Descrip: systems-level support code
**
** Revision History (most recent last)
**
** Tue Sep 21 10:30:23 1993 mazer
**  added ishiddenfile()
**
** Sun Jan 30 15:38:13 1994 mazer
**  added filelen()
**
*******************************************************************/

#include "xdphyslib.h"

/* a variant on strtok() which allows one to nest strtok calls */

#define STRNTOK_MAXN 10

char *strntok (char *s, const char *delim, int n)
{
  char *token;
  static char *olds[STRNTOK_MAXN];

  assert(n<STRNTOK_MAXN);

  if (s == NULL)
    s = olds[n];

  /* Scan leading delimiters.  */
  s += strspn (s, delim);
  if (*s == '\0')
    return NULL;

  /* Find the end of the token.  */
  token = s;
  s = strpbrk (token, delim);
  if (s == NULL)
    /* This token finishes the string.  */
    olds[n] = strchr (token, '\0');
  else
    {
      /* Terminate the token and make OLDS point past it.  */
      *s = '\0';
      olds[n] = s + 1;
    }
  return token;
}

#ifndef __GLIBC__
char *basename(char *path)
{
  char *p;

  if (path && (p = rindex(path, '/')))
    return(p + 1);
  else
    return(path);
}

char *dirname(char *path)
{
  static char p[256];
	char *q;

  if(path==NULL) return(NULL);
  if((q=rindex(path,'/'))==NULL) {
		strcpy(p,'.');
		return(p); }
	assert(q-path<256);
  strncpy(p,path,q-path);
  return(p);
}
#endif 

int ishiddenfile(char *path)
{
  return((int)(*basename(path) == '.'));
}

char *extension(char *path)
{
  char *p;

  if ((p = rindex(path, '/')) != NULL)
    return(rindex(p + 1, '.'));
  else
    return(rindex(path, '.'));
}

int probefile(char *path)
{
  struct stat buf;

  if (stat(findhome(path), &buf) == 0)
    return(buf.st_mtime);		/* file exists, return last mod time */
  else
    return(0);
}

int filelen(char *path)
{
  struct stat buf;

  if (stat(findhome(path), &buf) == 0)
    return((int)buf.st_size);
  else
    return(-1);
}

int isdir(char *path)
{
  struct stat buf;

  if (stat(findhome(path), &buf) == 0)
    return(buf.st_mode & S_IFDIR); /* if exists and is dir.. */
  else
    return(0);			/* doesn't even exist.. */
}

int filesize(char *path)
{
  struct stat buf;

  if (stat(findhome(path), &buf) == 0)
    return(buf.st_size);	/* file exists, return size */
  else
    return(-1);
}

char *envexpand(char *p)
{
  static char stash[MAXPATHLEN];
  char *v, *r, c;
  extern char *index(), *getenv();

  if (p == stash) {
    fprintf(stderr, "envexpand: illegal recursive call\n");
    exit(1);
  }
  *stash = 0;
  while (*p) {
    if (!strncmp(p, "$(", 2) && (r = index(p + 2, ')')) != NULL) {
      c = *r;
      *r = 0;
      v = getenv(p + 2);
      *r = c;
      if (v != NULL) {
	strcat(stash, v);
	p = r;
      } else {
	return(NULL);
      }
    } else {
      strncat(stash, p, 1);
    }
    p++;
  }
  return(stash);
}

/*
** findhome() ripped off from sc6.8, with minor changes
*/

char *findhome(char *path)
{
  char 		*p, *r, *v, tmp[MAXPATHLEN];
  static char	stash[MAXPATHLEN];
  static char	*HomeDir = NULL;
  extern char	*getenv();

  if (path == stash) {
    /* Usually, this means that it's already been expanding, as in:
    ** probefile(findhome("~/foo")), where probefile() calls findhome
    ** itself .. in this case, all should be ok..
    */
    fprintf(stderr, "warning: findhome called with stash\n\t<%s>\n", stash);
    return(stash);
  } else if (path == NULL) {
    return(NULL);
  } else if (*path == '~') {		/* if path starts with ~ */
    char *pathptr;
    char tmppath[MAXPATHLEN];
	
    if (HomeDir == NULL) {	/* if HomeDir uninitialized, initialize  */
      HomeDir = getenv("HOME");	/* set from the environment */
      if (HomeDir == NULL)	/* if not defined in env, default to root */
	HomeDir = "/";
    }
    pathptr = path + 1;		/* start just after the ~, is it USER's? */
    if ((*pathptr == '/') || (*pathptr == '\0')) {
      strcpy(tmppath, HomeDir);	/* yes, so use $HOME, stuff into tmppath*/
    } else {			/* otherwise, get it from getpwnam(..) */
      struct	passwd *pwent;
      extern	struct	passwd *getpwnam();
      char	*namep;
      char	name[50];
		
      namep = name;
      while ((*pathptr != '\0') && (*pathptr != '/'))
	*(namep++) = *(pathptr++);
      *namep = '\0';
      if ((pwent = getpwnam(name)) == NULL) {
	sprintf(path, "Can't find user %s", name);
	return(NULL);
      }
      strcpy(tmppath, pwent->pw_dir); /* put someone else's $HOME in tmppath */
    }
    strcat(tmppath, pathptr);	/* copy the post-~ or post-~USER/ to tmppath */
    strcpy(tmp, tmppath);
  } else {
    strcpy(tmp, path);
  }

  for (strcpy(stash, ""), p = tmp; *p; p++) {
    if (!strncmp(p, "$(", 2) && (r = index(p + 2, ')')) != NULL) {
      *r = 0;
      if ((v = getenv(p + 2)) != NULL) {
	strcat(stash, v);
	p = r;
      } else {
	fprintf(stderr, "warning: no env var \"%s\" not defined!\n", p + 2);
	strcat(stash, "$");
	*r = ')';
      }
    } else {
      strncat(stash, p, 1);
    }
  }
  return(stash);
}


int system_noblock(char *cmdstr)
{
  int pid;

  if ((pid = fork()) == 0) {
    system(cmdstr);
    exit(0);
  }
  return(pid);
}

void makeXDphysrc(void)
{
  char *p;

  if (!probefile("~/.xdphysrc")) {
    p = (char *) malloc(20);
    sprintf(p, "exec xdsetup");
    fprintf(stderr, "makeXDphysrc: building ~/.xdphysrc for you\007\n");
    system(p);
    free(p);
  } else if (!isdir("~/.xdphysrc")) {
    fprintf(stderr, "Bad news: ~/.xdphysrc must be a directory!\007\n");
    exit(1);
  }
}
