/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: statfns.h,v 2.54 1999/06/12 01:12:26 bjarthur Exp $
** Program: dowl
**  Module: statfns.h
**  Author: mazer
** Descrip: interface file for statfns.c
**
** Revision History (most recent last)
**
*******************************************************************/

#define MY_MIN(a,b) (((a)<(b)) ? (a) : (b))
#define MY_MAX(a,b) (((a)>(b)) ? (a) : (b))

extern void anova2(float***, int, int, int**,
      float*, float*, float*, float*, float*, float*);
extern float permutation_test_rand(float*, int, float*, int, int);
extern float permutation_test_bin(float*, int, float*, int);
extern float permutation_test_dp(int*, int, int*, int, int);

extern float mean(float*, int);
extern float quantile(float*, int, float);
extern float median(float*, int);
extern float stddev(float*, int);
extern float stderror(float*, int);
extern float mode(float*, int, float, float);
extern void combine_mean(float, int, float, int, float*);
extern void combine_stddev(float, float, int, float, float, int, float*);
extern void combine_stderr(float, float, int, float, float, int, float*);

extern int findPeak(int, float*, float*, float, float*, float*,
      float*, float*, float*, float*);
