/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: runstop.c,v 2.49 2001/03/27 06:59:27 cmalek Exp $
** Program: dowl
**  Module: runstop.c
**  Author: mazer
** Descrip: main user interface for data collection
**
** Revision History (most recent last)
**
** Sun May 17 19:51:48 1992 mazer
**  creation date :: excerpted from xdowl.c to generalize
**
** Wed Jan 27 15:58:13 1993 mazer
**  added MaybePause() -- see comments below
**
** Thu Mar 18 13:21:45 1993 mazer
**  Removed the Halt function .. now you must Pause and then
**  halt -- this avoids accidental abortion of runs!!
**
** Wed May 26 17:54:08 1993 mazer
**  added percirc stuff
**
*******************************************************************/

#include "xdphyslib.h"

#include "stop.bm"
#include "stopped.bm"
#include "record.bm"
#include "no_record.bm"

int progRunning = 0;

Widget status1 = NULL;
Widget status2 = NULL;
char  *this_run = NULL;

static int pause_next_chance = 0;
static Widget percirc = NULL;
static Widget pausebutton = NULL;
static Widget reclabel = NULL;
static Pixmap stop_pix, stopped_pix;
static Pixmap record_pix, no_record_pix;

/*
** MaybePause() function is designed to avoid timeout errors during
** time critical events, like calls to is_sample(). The Pause function
** will set the pause_next_chance flag and return right away. Modules
** need only periodically call MaybePause() when it's safe to actually
** pause -- like just after each is_sample() call.
**
** if this_run is NULL, then MaybePause assumes that there's no run
** in progress and just halts right away.. this is primarily in case
** you choose to use the stop key to halt the run panel
*/

void MaybePause()
{
  int i;
  char *p;
#ifndef rindex
  extern char *rindex();
#endif

  if (pause_next_chance && progRunning) {
    if (this_run == NULL) {
      set_progRunning(False);
      return;
    }

    pause_next_chance = 0;

    if (this_run) {
      if ((p = rindex(this_run, '/')) != NULL)
	p++;
      else
	p = this_run;
    } else {
      p = NULL;
    }

    while (1) {
      i = pop_box("Run Paused ...", "Halt", "Continue", "Plot so far..");

      switch (i)
	{
	case 1:
	  set_progRunning(False);
	  return;
	case 2:
	  button_on(pausebutton);
	  XtVaSetValues(pausebutton, XtNbitmap, stop_pix, NULL);
	  return;
	case 3:
          FDObj_File_New(this_run, NULL, NULL);
	  break;
	}
    }
  }
}

void recording(int yes)
{
	if (yes) {
		XtVaSetValues(reclabel, XtNbitmap, record_pix, NULL);
	} else {
		XtVaSetValues(reclabel, XtNbitmap, no_record_pix, NULL);
	}
}


void Pause(Widget w, XtPointer client_data, XtPointer call_data)
{
  if (progRunning) {
    pause_next_chance = 1;
    button_off(pausebutton);
    XtVaSetValues(pausebutton, XtNbitmap, stopped_pix, NULL);
    beep(0);
  }
}

void PauseAction(Widget w, XEvent *event, String *params,
      Cardinal *num_params)
{
  Pause(NULL,NULL,NULL);
}

void percdone(double f)
{
  int foo;

  if (percirc) {
    foo = (int)(f*10000);
/*
    if(foo == 10000)
      foo -= 1;
*/
    XfwfCircularPercentageSetPercentage(percirc, foo); }
}

void set_progRunning(int b)
{
  static Widget panel = NULL;
  Widget pform, form;

  pause_next_chance = 0;
  progRunning = b;
  if (progRunning) {
    if (panel == NULL) {
      panel = top_new(TopLevel, "RunStop");
      form = form_new(panel, "form", 0);
      pform = form_new(form, "form", 1);
      XtVaSetValues(pform,
		    XtNleft,		XawChainLeft,
		    XtNright,		XawChainLeft,
		    XtNtop,		XawChainTop,
		    XtNbottom,		XawChainTop,
		    NULL);

      record_pix = makePixmap(record_bits,record_width,record_height);
      no_record_pix = makePixmap(no_record_bits,no_record_width,
                            no_record_height);
      stop_pix = makePixmap(stop_bits,stop_width,stop_height);
      stopped_pix = makePixmap(stopped_bits,stopped_width,stopped_height);


      reclabel = pixlabel_new(pform, no_record_pix, NULL, NULL, 0);

      XtVaSetValues(reclabel,
#ifdef CHAINME
		    XtNleft,		XawChainLeft,
		    XtNright,		XawChainLeft,
		    XtNtop,		XawChainTop,
		    XtNbottom,		XawChainTop,
#else
		    XtNwidth,		no_record_width + 10,
		    XtNheight,		no_record_height + 10,
#endif
		    NULL);

      pausebutton = pixbutton_new(pform, stop_pix, Pause, 0, reclabel, NULL);
      XtVaSetValues(pausebutton,
#ifdef CHAINME
		    XtNleft,		XawChainLeft,
		    XtNright,		XawChainLeft,
		    XtNtop,		XawChainTop,
		    XtNbottom,		XawChainTop,
#else
		    XtNwidth,		stop_width + 10,
		    XtNheight,		stop_height + 10,
#endif
		    NULL);
      percirc =
	XtVaCreateManagedWidget("percdone",
				xfwfCircularPercentageWidgetClass, pform,
				XtNborderWidth, 0,
				XtNfromVert, 	NULL,
				XtNfromHoriz, 	pausebutton,
#ifdef CHAINME
				XtNleft,	XawChainLeft,
				XtNright,	XawChainLeft,
				XtNtop,		XawChainTop,
				XtNbottom,	XawChainTop,
#endif
				XtNheight,	stop_height + 10,
				XtNwidth,	stop_height + 10,
				NULL);


      status1 = statline_new(form, 1);
      XtVaSetValues(status1,
		    XtNfromHoriz, pform,
		    XtNfromVert, NULL,
		    XtNjustify, XtJustifyLeft,
		    NULL);
      status2 = statline_new(form, 1);
      XtVaSetValues(status2,
		    XtNfromHoriz, pform,
		    XtNfromVert, status1,
		    XtNjustify, XtJustifyLeft,
		    NULL);
    } else {
      XtVaSetValues(pausebutton, XtNbitmap, stop_pix, NULL);
    }
    beep(20);
    popup(panel);
    button_on(pausebutton);
  } else {
    beep(20);
    if (panel) {
      popdown(panel);
      button_off(pausebutton);
    }
  }
}
