/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: rover.h,v 2.42 1995/06/15 00:09:32 cmalek Exp $
** Program: dowl
**  Module: rover.h
**  Author: mazer
** Descrip: index->iid,itd unwraping macro
**
** Revision History (most recent last)
**
*******************************************************************/


/*
** unwrap(0) => negmost itd, negmost iid	-300us, -40db
** unwrap(1) => negmost+1 itd, netmost iid	-270us, -40db
**   .. etc ..
*/
   
#define unwrap(slist,i,itd2,iid2,tstart,tstep,istart,istep) { \
    (itd2) = (((int)(slist)[(i)]) % nitds) * tstep + tstart; \
      (iid2) = (((int)(slist)[(i)]) / nitds) * istep + istart; }

