/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: raster.h,v 1.11 2001/03/27 06:59:27 cmalek Exp $
** Program: dowl
**  Module: rasterfns.h
**  Author: mazer
** Descrip: interface description for rasterfns.c
**
** Revision History (most recent last)
**
*******************************************************************/

#ifndef _RASTER_H_
#define _RASTER_H_

#include "spike_t.h"
#include "fd.h"

typedef enum {
  GSR_ttl,			/* search for TTL events */
  GSR_window,			/* do simple window discrimination */
  GSR_ss,			/* use ml's ss package */
  GSR_invalid
} GSRMode;

extern int G_detect_curr,G_detect_color[4],G_detect_onoff[4];
extern int G_detect_x[4],G_detect_y[4];

#define N_SPIKES(spikelist)	   (spikelist)[0]
#define SPIKE_TIME(spikelist, i)   (spikelist)[1 + (2 * (i))] 
#define SPIKE_MSEC(spikelist, i)   (((float) SPIKE_TIME(spikelist,i))/ 10000.0)
#define SPIKE_SEC(spikelist, i)	   (((float) SPIKE_TIME(spikelist,i))/ 1e7)
#define SPIKE_CHAN(spikelist, i)   (spikelist)[2 + (2 * (i))]
#define alloc_raster(i)		   (spike_t *) calloc(2*(i)+1, sizeof(spike_t))
#define realloc_raster(spikelist, i)	(spike_t *) realloc((spikelist), (2*(i)+1)* sizeof(spike_t))

#define TTL_CODE			(-1)	/* ttl fiduciary event stamp */
#define OUTLIER_CODE	(-2)	/* outlier class event stamp */
#define MU_CODE				(-3)	/* user-code for collapse all to one */

#define matchEvent(chan,mask) ((mask == MU_CODE) || (chan == mask))

extern int 			countRaster(float, float, spike_t*, int);
extern spike_t *mergeRasters(spike_t*, spike_t*);
extern void 		writeRaster(FILE*, spike_t*, char*, float*);
extern spike_t *readRaster(FILE*, FILEDATA*, float**);
extern spike_t *getRaster(int, float**);

#if(0)
extern int   		getRaster_setmode(GSRMode); /* set the current gsr_mode */
#endif
extern int      getRaster_getmode(void);    /* get the current gsr_mode */
extern int   		getRaster_getnmodels(void); /* get the # of models (1..N)*/

/* get the ttl and analog inp bufs */
void spiker_getAnalogBuffers(int *, xword ***);
int spiker_getTTLbuffer(int *, xword **);

/* Routines for semi-fast//standardized spike matching */
extern int *makePatternVector(char*);    /* generate cached pattern vector */
extern void unmakePatternVector(int*);   /* un-generate cached pattern vector */
extern int  matchSpike(int, char*, int*);/* do the match, MAY take a pat_vec */

extern void printAvePMks(float*, int, int);

#endif /* _RASTER_H_ */
