/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: pm_nop.c,v 2.48 1998/07/22 18:15:59 bjarthur Exp $
** Program: xdphys
**  Module: pm_nop.c
**  Author: mazer
** Descrip: xdphys plot method -- dummy method -- no plot!!
**
** Revision History (most recent last)
**
** Fri Nov 11 14:35:46 1994 mazer
**  creation date
**
*******************************************************************/

#include "xdphyslib.h"
#include "xdphys.h"
#include "plotter.h"

static int nop_plotter(FDO *fdo, FILEDATA*, FDObj_ViewType*, int, FILE*);
static int nop_valid_view(FDO *, int);

static int **view_order = NULL;
static int nsubviews[] = {0};
static int nviews = 0;

int nop_do_plot(FDO *fdo, FILEDATA *fd, int view, int l, FILE *fptr)
{
  if (!nop_valid_view(fdo, view)) {
		pm_type_error("nop", view);
		view = PM_DEFAULT;
		(void) nop_valid_view(fdo, view); }

  switch(view) {
    case PM_DEFAULT:
  	default:
  		pm_type_error("mono", view);
  		break; }

  return(1);
}

static int nop_valid_view(FDO *fdo, int view)
{
	int retval = 0;
	int i,j;

	if (view == PM_DEFAULT) {
			retval = 1;
	} else {
		for (i=0; i<nviews; i++) {
			for (j=0; j<nsubviews[i]; j++) {
				if (view_order[i][j] == view) {
					retval = 1;
					fdo->view.lr = i;
					fdo->view.ud = j;
					break; } } } }

	return(retval);
}

static int nop_plotter(FDO *fdo, FILEDATA *fd, FDObj_ViewType *view,
			int l, FILE *fptr)
{
	return(1);
}

int pm_nop_init(void)
{
  setFDOvalidviewMethod("nop", nop_valid_view);
  setFDOdoplotMethod("nop", nop_do_plot);
  setFDOplotMethod("nop", nop_plotter);
  setFDreadMethod("nop", FD1_reader);
  setFDfreeMethod("nop", FD1_free);
  return(1);
}
