/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: pm_iid.c,v 2.59 1999/05/28 18:01:00 bjarthur Exp $
** Program: xdphys
**  Module: pm_iid.c
**  Author: mazer
** Descrip: xdphys plot method -- static iid tuning curve plotter
**
** Revision History (most recent last)
**
** Tue Nov  1 17:17:40 1994 mazer
**  - creation date :: from pm_itd.c 
**  - this is just to support the "contraipsi" preference feature
**    do tha IID curves can be plotted relative to c>i and i>c
**    instead of l>r and r>l
**
*******************************************************************/

#include "xdphyslib.h"
#include "xdphys.h"
#include "plotter.h"

static int iid_plotter(FDO*,FILEDATA*,FDObj_ViewType*,int,FILE*);
static void fit_menu(FDO*);
static int iid_valid_view(FDO *, int);

static int view_order[][3] = {
			{PM_CURVE},
			{PM_MEANPHASE, PM_VS, PM_RAYLEIGH},
			{PM_PERHIST},
			{PM_RASTER, PM_RASTER_RAW},
			{PM_PSTH},
			{PM_ISIH}};
static int nsubviews[] = {1,3,1,2,1,1};
static int nviews = 6;

int iid_do_plot(FDO *fdo, FILEDATA *fd, int view, int l, FILE *fptr)
{
  float period;
  int nbins;
  static int last_view=PM_NONE;

  if (!iid_valid_view(fdo, view)) {
		pm_type_error("iid", view);
		view = PM_DEFAULT;
		(void) iid_valid_view(fdo, view); }

  FD1_contra_ipsi(fd);

	FD_perhist_compute_period_nbins(fd,&period,&nbins);

  switch(view) {
    case PM_DEFAULT:
    case PM_CURVE:
      fit_menu(fdo);
      FD1_curveFN(fdo,fd,l,fptr);
      break;
    case PM_MEANPHASE:
      FD1_perhist1FN(fdo,fd,l,fptr,period,nbins,0);
      break;
    case PM_VS:
      FD1_perhist1FN(fdo,fd,l,fptr,period,nbins,1);
      break;
    case PM_RAYLEIGH:
      FD1_perhist1FN(fdo,fd,l,fptr,period,nbins,2);
      break;
    case PM_PERHIST: {
      if(last_view!=PM_PERHIST)
        fdo->vsm_data = VSM_ALL_CODE;
      FD1_perhist_stats_menu(fdo);
      FD_vsm_menu(fdo,1);
      FD1_perhist2FN(fdo,fd,l,fptr,period,nbins); }
      break;
    case PM_RASTER:
      FD1_rasterFN(fdo,fd,l,0,fptr);
      break;
    case PM_RASTER_RAW:
      FD1_rasterFN(fdo,fd,l,1,fptr);
      break;
    case PM_PSTH:
      FD1_psthFN(fdo,fd,l,fptr);
      break;
    case PM_ISIH:
      FD1_isih_stats_menu(fdo);
      FD1_isihFN(fdo,fd,l,fptr);
      break; 
		default:
			pm_type_error("iid", view);
			break; }

  last_view = view;
  return(1);
}

static int iid_valid_view(FDO *fdo, int view)
{
	int retval = 0;
	int i,j;

	if (view == PM_DEFAULT) {
			retval = 1;
	} else {
		for (i=0; i<nviews; i++) {
			for (j=0; j<nsubviews[i]; j++) {
				if (view_order[i][j] == view) {
					retval = 1;
					fdo->view.lr = i;
					fdo->view.ud = j;
					break; } } } }

	return(retval);
}


static int iid_plotter(FDO *fdo, FILEDATA *fd, FDObj_ViewType *view,
			int l, FILE *fptr)
{
  syn_spec ss;
  fd_syn_spec_parse(FD_GV(fdo->fds[l], "iid.Stim"),0,&ss);

  adjust_index(view->lr,view->ud);

  if(l==0) {
    if(!((ss.class == SC_TONE) || 
          ((ss.class == SC_STACK) && (ss.parms.stack.num_freqs == 1)))) {
	  	if(view->lr == 1) {
	  		view->lr = 3;
	  		view->ud = 0; }
	  	else if(view->lr == 2) {
	  		view->lr = 0;
	  		view->ud = 0; } } }
  else {
    if(!((ss.class == SC_TONE) || 
          ((ss.class == SC_STACK) && (ss.parms.stack.num_freqs == 1))))
	  	if((view->lr == 1) || (view->lr == 2)) {
        notify("some curves missing due to different stim types");
        return(0); } }

  if(!fdo->no_X) {
  if(nsubviews[view->lr]>1) {
    XtSetSensitive(fdo->up, True);
    XtSetSensitive(fdo->down, True); } }

  iid_do_plot(fdo, fd, view_order[view->lr][view->ud], l, fptr);

  return(1);
}

static void fit_menu(FDO *fdobj)
{
  if(fdobj->no_X) return;

  menubutton_clear(fdobj->fit,&(fdobj->fitpsh));
  XtSetSensitive(fdobj->fit, False);

  menubutton_add(fdobj->fitpsh,"peak stats", FD1_peak_stats,fdobj);
  menubutton_add(fdobj->fitpsh,"similarity stats", FD1_similarity_stats,fdobj);
  /*menubutton_add(fdobj->fitpsh,"linearity stats", LinearityStatsFN,fdobj);*/
  menubutton_add(fdobj->fitpsh,"combine",CombineDataFN,fdobj);
  menubutton_add(fdobj->fitpsh,"prob distribution", FD1_prob_distribution,fdobj);
  XtSetSensitive(fdobj->fit, True);
}

int pm_iid_init(void)
{
  setFDOvalidviewMethod("iid", iid_valid_view);
  setFDOdoplotMethod("iid", iid_do_plot);
  setFDOplotMethod("iid", iid_plotter);
  setFDreadMethod("iid", FD1_reader);
  setFDfreeMethod("iid", FD1_free);
  return(1);
}
