/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: pm_bja.c,v 2.1 2000/05/25 00:09:43 bjarthur Exp $
** Program: xdphys
**  Module: pm_bja.c
**  Author: bjarthur
** Descrip: xdphys plot method -- static itd tuning curve plotter
**
** Revision History (most recent last)
**
** 00.5 bjarthur
**   creation - copied from pm_itd.c
**
*******************************************************************/

#include "xdphyslib.h"
#include "plotter.h"

static int bja_plotter(FDO *fdo, FILEDATA*, FDObj_ViewType*, int, FILE*);
static int bja_valid_view(FDO *, int);

static int view_order[][3] = {
			{PM_CURVE},
			{PM_RASTER, PM_RASTER_RAW},
			{PM_PSTH},
			{PM_ISIH}};
static int nsubviews[] = {1,2,1,1};
static int nviews = 6;

int bja_do_plot(FDO *fdo, FILEDATA *fd, int view, int l, FILE *fptr)
{
  float period;
  int nbins;
  static int last_view=PM_NONE;

  if (!bja_valid_view(fdo, view)) {
		pm_type_error("bja", view);
		view = PM_DEFAULT;
		(void) bja_valid_view(fdo, view); }

  FD1_contra_ipsi(fd);
 
	FD_perhist_compute_period_nbins(fd, &period, &nbins);

  switch(view) {
    case PM_DEFAULT:
    case PM_CURVE:
      FD1_curveFN(fdo,fd,l,fptr);
      break;
    case PM_RASTER:
      FD1_rasterFN(fdo,fd,l,0,fptr);
      break;
    case PM_RASTER_RAW:
      FD1_rasterFN(fdo,fd,l,1,fptr);
      break;
    case PM_PSTH:
      FD1_psthFN(fdo,fd,l,fptr);
      break;
    case PM_ISIH:
      FD1_isih_stats_menu(fdo);
      FD1_isihFN(fdo,fd,l,fptr);
      break; 
		default:
			pm_type_error("bja", view);
			break; }

  last_view = view;
  return(1);
}

static int bja_valid_view(FDO *fdo, int view)
{
	int retval = 0;
	int i,j;

	if (view == PM_DEFAULT) {
			retval = 1;
	} else {
		for (i=0; i<nviews; i++) { for (j=0; j<nsubviews[i]; j++) {
				if (view_order[i][j] == view) {
					retval = 1;
					fdo->view.lr = i;
					fdo->view.ud = j;
					break; } } } }

	return(retval);
}

static int bja_plotter(FDO *fdo, FILEDATA *fd, FDObj_ViewType *view,
			int l, FILE *fptr)
{
  adjust_index(view->lr,view->ud);

  if(!fdo->no_X) {
  if(nsubviews[view->lr]>1) {
    XtSetSensitive(fdo->up, True);
    XtSetSensitive(fdo->down, True); } }
 
  bja_do_plot(fdo, fd, view_order[view->lr][view->ud], l, fptr);

  return(1);
}

int pm_bja_init(void)
{
  setFDOvalidviewMethod("bja", bja_valid_view);
  setFDOdoplotMethod("bja", bja_do_plot);
  setFDOplotMethod("bja", bja_plotter);
  setFDreadMethod("bja", FD1_reader);
  setFDfreeMethod("bja", FD1_free);
  return(1);
}
