/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: pm_bc.c,v 1.6 1999/05/18 19:17:13 bjarthur Exp $
** Program: dowl
**  Module: pm_bc.c
**  Author: bjarthur
** Descrip: xdowl plot method -- static bc tuning curve plotter
**
** Revision History (most recent last)
**
** 97.2 bjarthur
**   created date.  copied from pm_itd.c
**
*******************************************************************/

#include "xdphyslib.h"
#include "plotter.h"

static int bc_plotter(FDO *fdo, FILEDATA*, FDObj_ViewType*, int, FILE*);
static int bc_valid_view(FDO *, int);

static int view_order[][2] = {
			{PM_CURVE},
			{PM_RASTER, PM_RASTER_RAW},
			{PM_PSTH},
			{PM_ISIH}};
static int nsubviews[] = {1,2,1,1};
static int nviews = 4;

int bc_do_plot(FDO *fdo, FILEDATA *fd, int view, int l, FILE *fptr)
{
  if (!bc_valid_view(fdo, view)) {
		pm_type_error("bc", view);
		view = PM_DEFAULT;
		(void) bc_valid_view(fdo, view); }

  switch(view) {
    case PM_DEFAULT:
    case PM_CURVE:
      FD1_curveFN(fdo,fd,l,fptr);
      break;
    case PM_RASTER:
      FD1_rasterFN(fdo,fd,l,0,fptr);
      break;
    case PM_RASTER_RAW:
      FD1_rasterFN(fdo,fd,l,1,fptr);
      break;
    case PM_PSTH:
      FD1_psthFN(fdo,fd,l,fptr);
      break;
    case PM_ISIH:
      FD1_isih_stats_menu(fdo);
      FD1_isihFN(fdo,fd,l,fptr);
      break; 
		default:
			pm_type_error("bc", view);
			break; }

  return(1);
}

static int bc_valid_view(FDO *fdo, int view)
{
	int retval = 0;
	int i,j;

	if (view == PM_DEFAULT) {
			retval = 1;
	} else {
		for (i=0; i<nviews; i++) {
			for (j=0; j<nsubviews[i]; j++) {
				if (view_order[i][j] == view) {
					retval = 1;
					fdo->view.lr = i;
					fdo->view.ud = j;
					break; } } } }

	return(retval);
}

static int bc_plotter(FDO *fdo, FILEDATA *fd, FDObj_ViewType *view,
			int l, FILE *fptr)
{
  adjust_index(view->lr,view->ud);

  if(nsubviews[view->lr]>1) {
    XtSetSensitive(fdo->up, True);
    XtSetSensitive(fdo->down, True); }
 
  bc_do_plot(fdo, fd, view_order[view->lr][view->ud], l, fptr);

  return(1);
}

int pm_bc_init(void)
{
  setFDOvalidviewMethod("bc", bc_valid_view);
  setFDOdoplotMethod("bc", bc_do_plot);
  setFDOplotMethod("bc", bc_plotter);
  setFDreadMethod("bc", FD1_reader);
  setFDfreeMethod("bc", FD1_free);
  return(1);
}
